package org.intellij.markdown.ast

import com.intellij.psi.tree.IElementType
import kala.text.StringSlice

fun ASTNode.getParentOfType(vararg types: IElementType): ASTNode? {
  var currentNode = parent
  while (currentNode != null && !types.contains(currentNode.type)) {
    currentNode = currentNode.parent
  }
  return currentNode
}

fun ASTNode.getTextInNode(allFileText: String): StringSlice {
  return StringSlice.of(allFileText, startOffset, endOffset)
}
