package org.intellij.markdown.flavours.gfm

import kala.collection.Seq
import org.intellij.markdown.MarkdownTokenTypes
import org.intellij.markdown.flavours.commonmark.CommonMarkFlavourDescriptor
import org.intellij.markdown.flavours.gfm.lexer._GFMLexer
import org.intellij.markdown.lexer.MarkdownLexer
import org.intellij.markdown.parser.MarkerProcessorFactory
import org.intellij.markdown.parser.sequentialparsers.EmphasisLikeParser
import org.intellij.markdown.parser.sequentialparsers.SequentialParser
import org.intellij.markdown.parser.sequentialparsers.SequentialParserManager
import org.intellij.markdown.parser.sequentialparsers.impl.*

/**
 * GitHub Markdown spec based flavour, to be used as a base for other flavours.
 *
 * @param absolutizeAnchorLinks `true` if anchor links (e.g. `#foo`) should be resolved against `baseURI` and
 * `false` otherwise
 *
 * @param makeHttpsAutoLinks enables use of HTTPS schema for auto links.
 */
open class GFMFlavourDescriptor(
  absolutizeAnchorLinks: Boolean = false,
  private val makeHttpsAutoLinks: Boolean = false,
) : CommonMarkFlavourDescriptor(absolutizeAnchorLinks) {
  override val markerProcessorFactory: MarkerProcessorFactory = GFMMarkerProcessor.Factory

  override fun createInlinesLexer(): MarkdownLexer {
    return MarkdownLexer(_GFMLexer())
  }

  override val sequentialParserManager = object : SequentialParserManager() {
    override fun getParserSequence(): Seq<SequentialParser> {
      return Seq.of(
        AutolinkParser(Seq.of(MarkdownTokenTypes.AUTOLINK, GFMTokenTypes.GFM_AUTOLINK)),
        BacktickParser(),
        MathParser(),
        ImageParser(),
        InlineLinkParser(),
        ReferenceLinkParser(),
        EmphasisLikeParser(EmphStrongDelimiterParser(), StrikeThroughDelimiterParser()),
      )
    }
  }
}
