/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.flavours.gfm.StrikeThroughDelimiterParserKt;
import org.intellij.markdown.parser.sequentialparsers.DelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.intellij.markdown.parser.sequentialparsers.impl.EmphStrongDelimiterParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J2\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/intellij/markdown/flavours/gfm/StrikeThroughDelimiterParser;", "Lorg/intellij/markdown/parser/sequentialparsers/DelimiterParser;", "<init>", "()V", "scan", "", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "iterator", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "delimiters", "", "Lorg/intellij/markdown/parser/sequentialparsers/DelimiterParser$Info;", "process", "", "result", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResultBuilder;", "jb-md"})
public final class StrikeThroughDelimiterParser
extends DelimiterParser {
    @Override
    public int scan(@NotNull TokensCache tokens, @NotNull TokensCache.Iterator iterator, @NotNull List<DelimiterParser.Info> delimiters) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        Intrinsics.checkNotNullParameter(delimiters, (String)"delimiters");
        if (!Intrinsics.areEqual((Object)iterator.getType(), (Object)GFMTokenTypes.TILDE)) {
            return 0;
        }
        int stepsToAdvance = 1;
        TokensCache.Iterator rightIterator = iterator;
        for (int index = 0; index < 50 && Intrinsics.areEqual((Object)rightIterator.rawLookup(1), (Object)GFMTokenTypes.TILDE); ++index) {
            rightIterator = rightIterator.advance();
            ++stepsToAdvance;
        }
        Pair<Boolean, Boolean> pair = this.canOpenClose(tokens, iterator, rightIterator, true);
        boolean canOpen = (Boolean)pair.component1();
        boolean canClose = (Boolean)pair.component2();
        int n = stepsToAdvance;
        for (int index = 0; index < n; ++index) {
            DelimiterParser.Info info = new DelimiterParser.Info(GFMTokenTypes.TILDE, iterator.getIndex() + index, 0, canOpen, canClose, '~', 0, 64, null);
            delimiters.add(info);
        }
        return stepsToAdvance;
    }

    @Override
    public void process(@NotNull TokensCache tokens, @NotNull TokensCache.Iterator iterator, @NotNull List<DelimiterParser.Info> delimiters, @NotNull SequentialParser.ParsingResultBuilder result) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        Intrinsics.checkNotNullParameter(delimiters, (String)"delimiters");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        int index = delimiters.size() - 1;
        while (index > 0) {
            if (!StrikeThroughDelimiterParserKt.access$isOpeningTilde(delimiters.get(index))) {
                --index;
                continue;
            }
            int openerIndex = index;
            int closerIndex = delimiters.get(index).getCloserIndex();
            int delimitersMatched = 1;
            while (EmphStrongDelimiterParser.Companion.areAdjacentSameMarkers(delimiters, openerIndex, closerIndex)) {
                --openerIndex;
                ++closerIndex;
                ++delimitersMatched;
            }
            if (delimitersMatched < 3) {
                DelimiterParser.Info opener = delimiters.get(openerIndex);
                DelimiterParser.Info closer = delimiters.get(closerIndex);
                result.withNode(new SequentialParser.Node(new IntRange(opener.getPosition(), closer.getPosition() + 1), GFMElementTypes.STRIKETHROUGH));
            }
            index = openerIndex - 1;
        }
    }
}

