/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.lexer;

import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.lexer.GeneratedLexer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0016\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0014\u001a\u00020\u00102\b\b\u0002\u0010\u001a\u001a\u00020\u0010J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u001dH\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\u0007H\u0002J&\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u001e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u001a\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013\u00a8\u0006("}, d2={"Lorg/intellij/markdown/lexer/MarkdownLexer;", "", "baseLexer", "Lorg/intellij/markdown/lexer/GeneratedLexer;", "<init>", "(Lorg/intellij/markdown/lexer/GeneratedLexer;)V", "value", "Lcom/intellij/psi/tree/IElementType;", "type", "getType", "()Lcom/intellij/psi/tree/IElementType;", "nextType", "", "originalText", "getOriginalText", "()Ljava/lang/CharSequence;", "", "bufferStart", "getBufferStart", "()I", "bufferEnd", "getBufferEnd", "tokenStart", "getTokenStart", "tokenEnd", "getTokenEnd", "state", "getState", "start", "", "advance", "", "locateToken", "calcNextType", "advanceBase", "reset", "buffer", "end", "initialState", "Companion", "jb-md"})
@SourceDebugExtension(value={"SMAP\nMarkdownLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownLexer.kt\norg/intellij/markdown/lexer/MarkdownLexer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public class MarkdownLexer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeneratedLexer baseLexer;
    @Nullable
    private IElementType type;
    @Nullable
    private IElementType nextType;
    @NotNull
    private CharSequence originalText;
    private int bufferStart;
    private int bufferEnd;
    private int tokenStart;
    private int tokenEnd;
    private final int state;
    @NotNull
    private static final Set<IElementType> TOKENS_TO_MERGE;

    public MarkdownLexer(@NotNull GeneratedLexer baseLexer) {
        Intrinsics.checkNotNullParameter((Object)baseLexer, (String)"baseLexer");
        this.baseLexer = baseLexer;
        this.originalText = "";
        this.state = this.baseLexer.getState();
    }

    @Nullable
    public final IElementType getType() {
        return this.type;
    }

    @NotNull
    public final CharSequence getOriginalText() {
        return this.originalText;
    }

    public final int getBufferStart() {
        return this.bufferStart;
    }

    public final int getBufferEnd() {
        return this.bufferEnd;
    }

    public final int getTokenStart() {
        return this.tokenStart;
    }

    public final int getTokenEnd() {
        return this.tokenEnd;
    }

    public final int getState() {
        return this.state;
    }

    public final void start(@NotNull CharSequence originalText, int bufferStart, int bufferEnd, int state) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        this.reset(originalText, bufferStart, bufferEnd, state);
        this.calcNextType();
    }

    public static /* synthetic */ void start$default(MarkdownLexer markdownLexer, CharSequence charSequence, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: start");
        }
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = charSequence.length();
        }
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        markdownLexer.start(charSequence, n, n2, n3);
    }

    public final boolean advance() {
        return this.locateToken();
    }

    private final boolean locateToken() {
        this.type = this.nextType;
        this.tokenStart = this.tokenEnd;
        if (this.type == null) {
            return false;
        }
        this.calcNextType();
        return true;
    }

    private final void calcNextType() {
        IElementType it;
        do {
            this.tokenEnd = this.baseLexer.getTokenEnd();
            this.nextType = this.advanceBase();
            it = this.type;
            boolean bl = false;
        } while (Intrinsics.areEqual((Object)this.nextType, (Object)it) && it != null && TOKENS_TO_MERGE.contains(it));
    }

    private final IElementType advanceBase() {
        return this.baseLexer.advance();
    }

    public final void reset(@NotNull CharSequence buffer, int start, int end, int initialState) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.originalText = buffer;
        this.bufferStart = start;
        this.bufferEnd = end;
        this.baseLexer.reset(buffer, start, end, initialState);
        this.type = this.advanceBase();
        this.tokenStart = this.baseLexer.getTokenStart();
    }

    static {
        Object[] objectArray = new IElementType[]{MarkdownTokenTypes.TEXT, MarkdownTokenTypes.WHITE_SPACE, MarkdownTokenTypes.CODE_LINE, MarkdownTokenTypes.LINK_ID, MarkdownTokenTypes.LINK_TITLE, MarkdownTokenTypes.URL, MarkdownTokenTypes.AUTOLINK, MarkdownTokenTypes.EMAIL_AUTOLINK, MarkdownTokenTypes.BAD_CHARACTER};
        TOKENS_TO_MERGE = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/intellij/markdown/lexer/MarkdownLexer$Companion;", "", "<init>", "()V", "TOKENS_TO_MERGE", "", "Lcom/intellij/psi/tree/IElementType;", "jb-md"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

