/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import kala.collection.Seq;
import kala.collection.immutable.ImmutableSeq;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.ExperimentalApi;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeBuilder;
import org.intellij.markdown.ast.CompositeASTNode;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.parser.CancellationToken;
import org.intellij.markdown.parser.InlineBuilder;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.TopLevelBuilder;
import org.intellij.markdown.parser.sequentialparsers.LexerBasedTokensCache;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001dB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\u0005J&\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\"\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\u0005H\u0002J(\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u001c\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/intellij/markdown/parser/MarkdownParser;", "", "flavour", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "assertionsEnabled", "", "cancellationToken", "Lorg/intellij/markdown/parser/CancellationToken;", "<init>", "(Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;ZLorg/intellij/markdown/parser/CancellationToken;)V", "(Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;)V", "(Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;Z)V", "buildMarkdownTreeFromString", "Lorg/intellij/markdown/ast/ASTNode;", "text", "", "parse", "root", "Lcom/intellij/psi/tree/IElementType;", "parseInlines", "parseInline", "", "textStart", "", "textEnd", "doParse", "doParseInline", "topLevelFallback", "inlineFallback", "InlineExpandingASTNodeBuilder", "jb-md"})
public final class MarkdownParser {
    @NotNull
    private final MarkdownFlavourDescriptor flavour;
    private final boolean assertionsEnabled;
    @NotNull
    private final CancellationToken cancellationToken;

    @ExperimentalApi
    public MarkdownParser(@NotNull MarkdownFlavourDescriptor flavour, boolean assertionsEnabled, @NotNull CancellationToken cancellationToken) {
        Intrinsics.checkNotNullParameter((Object)flavour, (String)"flavour");
        Intrinsics.checkNotNullParameter((Object)cancellationToken, (String)"cancellationToken");
        this.flavour = flavour;
        this.assertionsEnabled = assertionsEnabled;
        this.cancellationToken = cancellationToken;
    }

    public /* synthetic */ MarkdownParser(MarkdownFlavourDescriptor markdownFlavourDescriptor, boolean bl, CancellationToken cancellationToken, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            cancellationToken = CancellationToken.NonCancellable.INSTANCE;
        }
        this(markdownFlavourDescriptor, bl, cancellationToken);
    }

    public MarkdownParser(@NotNull MarkdownFlavourDescriptor flavour) {
        Intrinsics.checkNotNullParameter((Object)flavour, (String)"flavour");
        this(flavour, true);
    }

    public MarkdownParser(@NotNull MarkdownFlavourDescriptor flavour, boolean assertionsEnabled) {
        Intrinsics.checkNotNullParameter((Object)flavour, (String)"flavour");
        this(flavour, assertionsEnabled, CancellationToken.NonCancellable.INSTANCE);
    }

    @NotNull
    public final ASTNode buildMarkdownTreeFromString(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.parse(MarkdownElementTypes.MARKDOWN_FILE, text, true);
    }

    @NotNull
    public final ASTNode parse(@NotNull IElementType root, @NotNull String text, boolean parseInlines) {
        ASTNode aSTNode;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            aSTNode = this.doParse(root, text, parseInlines);
        }
        catch (MarkdownParsingException e) {
            if (this.assertionsEnabled) {
                throw e;
            }
            aSTNode = this.topLevelFallback(root, text);
        }
        return aSTNode;
    }

    public static /* synthetic */ ASTNode parse$default(MarkdownParser markdownParser, IElementType iElementType, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return markdownParser.parse(iElementType, string, bl);
    }

    @NotNull
    public final ASTNode parseInline(@NotNull IElementType root, @NotNull CharSequence text, int textStart, int textEnd) {
        ASTNode aSTNode;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            aSTNode = this.doParseInline(root, text, textStart, textEnd);
        }
        catch (MarkdownParsingException e) {
            if (this.assertionsEnabled) {
                throw e;
            }
            aSTNode = this.inlineFallback(root, textStart, textEnd);
        }
        return aSTNode;
    }

    private final ASTNode doParse(IElementType root, String text, boolean parseInlines) {
        ProductionHolder productionHolder = new ProductionHolder();
        MarkerProcessor<?> markerProcessor = this.flavour.getMarkerProcessorFactory().createMarkerProcessor(productionHolder);
        ProductionHolder.Marker rootMarker = productionHolder.mark();
        LookaheadText textHolder = new LookaheadText(text);
        LookaheadText.Position pos = textHolder.getStartPosition();
        while (pos != null) {
            this.cancellationToken.checkCancelled();
            productionHolder.updatePosition(pos.getOffset());
            pos = markerProcessor.processPosition(pos);
        }
        productionHolder.updatePosition(text.length());
        markerProcessor.flushMarkers();
        rootMarker.done(root);
        ASTNodeBuilder nodeBuilder = parseInlines ? (ASTNodeBuilder)new InlineExpandingASTNodeBuilder(text) : new ASTNodeBuilder(text);
        TopLevelBuilder builder = new TopLevelBuilder(nodeBuilder);
        return builder.buildTree(productionHolder.getProduction());
    }

    static /* synthetic */ ASTNode doParse$default(MarkdownParser markdownParser, IElementType iElementType, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return markdownParser.doParse(iElementType, string, bl);
    }

    private final ASTNode doParseInline(IElementType root, CharSequence text, int textStart, int textEnd) {
        MarkdownLexer lexer = this.flavour.createInlinesLexer();
        MarkdownLexer.start$default(lexer, text, textStart, textEnd, 0, 8, null);
        LexerBasedTokensCache tokensCache = new LexerBasedTokensCache(lexer);
        IntRange wholeRange = new IntRange(0, tokensCache.getFilteredTokens().size());
        Collection<SequentialParser.Node> nodes = this.flavour.getSequentialParserManager().runParsingSequence(tokensCache, SequentialParserUtil.INSTANCE.filterBlockquotes(tokensCache, wholeRange), this.cancellationToken);
        InlineBuilder builder = new InlineBuilder(new ASTNodeBuilder(text, this.cancellationToken), tokensCache, this.cancellationToken);
        return builder.buildTree(CollectionsKt.plus(nodes, (Iterable)CollectionsKt.listOf((Object)new SequentialParser.Node(wholeRange, root))));
    }

    private final ASTNode topLevelFallback(IElementType root, String text) {
        ImmutableSeq immutableSeq = ImmutableSeq.of((Object)this.inlineFallback(MarkdownElementTypes.PARAGRAPH, 0, text.length()));
        Intrinsics.checkNotNullExpressionValue((Object)immutableSeq, (String)"of(...)");
        return new CompositeASTNode(root, (Seq<ASTNode>)((Seq)immutableSeq));
    }

    private final ASTNode inlineFallback(IElementType root, int textStart, int textEnd) {
        ImmutableSeq immutableSeq = ImmutableSeq.of((Object)new LeafASTNode(MarkdownTokenTypes.TEXT, textStart, textEnd));
        Intrinsics.checkNotNullExpressionValue((Object)immutableSeq, (String)"of(...)");
        return new CompositeASTNode(root, (Seq<ASTNode>)((Seq)immutableSeq));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/markdown/parser/MarkdownParser$InlineExpandingASTNodeBuilder;", "Lorg/intellij/markdown/ast/ASTNodeBuilder;", "text", "", "<init>", "(Lorg/intellij/markdown/parser/MarkdownParser;Ljava/lang/CharSequence;)V", "createLeafNodes", "Lkala/collection/Seq;", "Lorg/intellij/markdown/ast/ASTNode;", "type", "Lcom/intellij/psi/tree/IElementType;", "startOffset", "", "endOffset", "jb-md"})
    private final class InlineExpandingASTNodeBuilder
    extends ASTNodeBuilder {
        public InlineExpandingASTNodeBuilder(CharSequence text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text);
        }

        @Override
        @NotNull
        public Seq<ASTNode> createLeafNodes(@NotNull IElementType type, int startOffset, int endOffset) {
            Seq<ASTNode> seq;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            IElementType iElementType = type;
            if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.PARAGRAPH) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.ATX_CONTENT) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.SETEXT_CONTENT) || Intrinsics.areEqual((Object)iElementType, (Object)GFMTokenTypes.CELL)) {
                Seq<ASTNode> seq2 = Seq.of((Object)MarkdownParser.this.parseInline(type, this.getText(), startOffset, endOffset));
                seq = seq2;
                Intrinsics.checkNotNullExpressionValue((Object)seq2, (String)"of(...)");
            } else {
                seq = super.createLeafNodes(type, startOffset, endOffset);
            }
            return seq;
        }
    }
}

