/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks;

import kala.text.StringSlice;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\b\u0018\u00010\u0007R\u00020\b2\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\f\u001a\u00020\u0005J\u001a\u0010\r\u001a\u00020\u000e2\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0012\u001a\b\u0018\u00010\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u00a8\u0006\u0013"}, d2={"Lorg/intellij/markdown/parser/markerblocks/MarkdownParserUtil;", "", "<init>", "()V", "calcNumberOfConsequentEols", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "getFirstNonWhitespaceLinePos", "eolsToSkip", "hasCodeBlockIndent", "", "isEmptyOrSpaces", "s", "", "findNonEmptyLineWithSameConstraints", "jb-md"})
@SourceDebugExtension(value={"SMAP\nMarkdownParserUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownParserUtil.kt\norg/intellij/markdown/parser/markerblocks/MarkdownParserUtil\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,101:1\n107#2,3:102\n111#2:106\n107#3:105\n*S KotlinDebug\n*F\n+ 1 MarkdownParserUtil.kt\norg/intellij/markdown/parser/markerblocks/MarkdownParserUtil\n*L\n10#1:102,3\n10#1:106\n10#1:105\n*E\n"})
public final class MarkdownParserUtil {
    @NotNull
    public static final MarkdownParserUtil INSTANCE = new MarkdownParserUtil();

    private MarkdownParserUtil() {
    }

    public final int calcNumberOfConsequentEols(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Compat compat = Compat.INSTANCE;
        boolean condition$iv = pos.getOffsetInCurrentLine() == -1;
        boolean $i$f$assert = false;
        if (!condition$iv) {
            boolean bl = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
        LookaheadText.Position currentPos = pos;
        int result = 1;
        Function1 isClearLine = arg_0 -> MarkdownParserUtil.calcNumberOfConsequentEols$lambda$0(constraints, arg_0);
        while (((Boolean)isClearLine.invoke((Object)currentPos)).booleanValue() && currentPos.nextLinePosition() != null && ++result <= 4) {
        }
        return result;
    }

    @Nullable
    public final LookaheadText.Position getFirstNonWhitespaceLinePos(@NotNull LookaheadText.Position pos, int eolsToSkip) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        LookaheadText.Position currentPos = null;
        currentPos = pos;
        int n = eolsToSkip - 1;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            if (pos.nextLinePosition() != null) continue;
            return null;
        }
        while (currentPos.charsToNonWhitespace() == null) {
            if (currentPos.nextLinePosition() != null) continue;
            return null;
        }
        return currentPos;
    }

    public final boolean hasCodeBlockIndent(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        int constraintsLength = MarkdownConstraintsKt.getCharsEaten(constraints, pos.getCurrentLine());
        if (pos.getOffsetInCurrentLine() >= constraintsLength + 4) {
            return true;
        }
        int i = constraintsLength;
        int n = pos.getOffsetInCurrentLine();
        if (i <= n) {
            while (true) {
                if (pos.getCurrentLine().charAt(i) == '\t') {
                    return true;
                }
                if (i == n) break;
                ++i;
            }
        }
        return false;
    }

    public final boolean isEmptyOrSpaces(@NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    @Nullable
    public final LookaheadText.Position findNonEmptyLineWithSameConstraints(@NotNull MarkdownConstraints constraints, @NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        LookaheadText.Position currentPos = pos;
        MarkdownConstraints nextLineConstraints;
        while (MarkdownConstraintsKt.upstreamWith(nextLineConstraints = MarkdownConstraintsKt.applyToNextLineAndAddModifiers(constraints, currentPos), constraints) && MarkdownConstraintsKt.extendsPrev(nextLineConstraints, constraints)) {
            StringSlice stringAfterConstraints = MarkdownConstraintsKt.eatItselfFromString(nextLineConstraints, currentPos.getCurrentLine());
            if (!INSTANCE.isEmptyOrSpaces((CharSequence)stringAfterConstraints)) {
                return currentPos;
            }
            if (currentPos.nextLinePosition() != null) continue;
            return null;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean calcNumberOfConsequentEols$lambda$0(MarkdownConstraints $constraints, LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        MarkdownConstraints currentConstraints = $constraints.applyToNextLine(pos);
        int constraintsLength = MarkdownConstraintsKt.getCharsEaten(currentConstraints, pos.getCurrentLine());
        if (!MarkdownConstraintsKt.upstreamWith(currentConstraints, $constraints)) return false;
        if (constraintsLength >= pos.getCurrentLine().length()) return true;
        LookaheadText.Position position = pos.nextPosition(1 + constraintsLength);
        if (position == null) return true;
        Integer n = position.charsToNonWhitespace();
        if (n != null) return false;
        return true;
    }
}

