/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\u000e2\n\u0010\u0010\u001a\u00060\u0011R\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\tH\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0014\u0010\u001a\u001a\u00020\t2\n\u0010\u0010\u001a\u00060\u0011R\u00020\u0012H\u0014J\u001c\u0010\u001b\u001a\u00020\u001c2\n\u0010\u0010\u001a\u00060\u0011R\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0003H\u0014R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/intellij/markdown/parser/markerblocks/impl/AtxHeaderMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "myConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "headerRange", "Lkotlin/ranges/IntRange;", "tailStartPos", "", "endOfLinePos", "<init>", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;Lkotlin/ranges/IntRange;II)V", "allowsSubBlocks", "", "isInterestingOffset", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "nodeType", "Lcom/intellij/psi/tree/IElementType;", "calcNodeType", "headerSize", "getDefaultNodeType", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "calcNextInterestingOffset", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "jb-md"})
public final class AtxHeaderMarkerBlock
extends MarkerBlockImpl {
    @NotNull
    private final IElementType nodeType;

    public AtxHeaderMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder, @NotNull IntRange headerRange, int tailStartPos, int endOfLinePos) {
        List list;
        Intrinsics.checkNotNullParameter((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)headerRange, (String)"headerRange");
        super(myConstraints, productionHolder.mark());
        int curPos = productionHolder.getCurrentPosition();
        List $this$_init__u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$_init__u24lambda_u240.add(new SequentialParser.Node(new IntRange(curPos + headerRange.getFirst(), curPos + headerRange.getLast() + 1), MarkdownTokenTypes.ATX_HEADER));
        if (curPos + headerRange.getLast() + 1 != tailStartPos) {
            $this$_init__u24lambda_u240.add(new SequentialParser.Node(new IntRange(curPos + headerRange.getLast() + 1, tailStartPos), MarkdownTokenTypes.ATX_CONTENT));
        }
        if (tailStartPos != endOfLinePos) {
            $this$_init__u24lambda_u240.add(new SequentialParser.Node(new IntRange(tailStartPos, endOfLinePos), MarkdownTokenTypes.ATX_HEADER));
        }
        List nodes = CollectionsKt.build((List)list);
        productionHolder.addProduction(nodes);
        this.nodeType = this.calcNodeType(headerRange.getLast() - headerRange.getFirst() + 1);
    }

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    private final IElementType calcNodeType(int headerSize) {
        switch (headerSize) {
            case 1: {
                return MarkdownElementTypes.ATX_1;
            }
            case 2: {
                return MarkdownElementTypes.ATX_2;
            }
            case 3: {
                return MarkdownElementTypes.ATX_3;
            }
            case 4: {
                return MarkdownElementTypes.ATX_4;
            }
            case 5: {
                return MarkdownElementTypes.ATX_5;
            }
            case 6: {
                return MarkdownElementTypes.ATX_6;
            }
        }
        return MarkdownElementTypes.ATX_6;
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return this.nodeType;
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)currentConstraints, (String)"currentConstraints");
        if (pos.getOffsetInCurrentLine() == -1) {
            return new MarkerBlock.ProcessingResult(MarkerBlock.ClosingAction.DROP, MarkerBlock.ClosingAction.DONE, MarkerBlock.EventAction.PROPAGATE);
        }
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }
}

