/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kala.text.StringSlice;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.AtxHeaderMarkerBlock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J*\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\u0010\b\u001a\u00060\tR\u00020\nH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/AtxHeaderProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "<init>", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "calcTailStartPos", "", "headerSize", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "matches", "Lkotlin/ranges/IntRange;", "jb-md"})
public final class AtxHeaderProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        IntRange headerRange = this.matches(pos);
        if (headerRange != null) {
            return CollectionsKt.listOf((Object)new AtxHeaderMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, headerRange, this.calcTailStartPos(pos, headerRange.getLast()), pos.getNextLineOrEofOffset()));
        }
        return CollectionsKt.emptyList();
    }

    private final int calcTailStartPos(LookaheadText.Position pos, int headerSize) {
        int offset;
        StringSlice line = pos.getCurrentLineFromPosition();
        for (offset = line.length() - 1; offset > headerSize && CharsKt.isWhitespace((char)line.charAt(offset)); --offset) {
        }
        while (offset > headerSize && line.charAt(offset) == '#' && line.charAt(offset - 1) != '\\') {
            --offset;
        }
        if (offset + 1 < line.length() && CharsKt.isWhitespace((char)line.charAt(offset)) && line.charAt(offset + 1) == '#') {
            return pos.getOffset() + offset + 1;
        }
        return pos.getOffset() + line.length();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        return this.matches(pos) != null;
    }

    private final IntRange matches(LookaheadText.Position pos) {
        if (pos.getOffsetInCurrentLine() != -1) {
            Object[] objectArray;
            StringSlice text = pos.getCurrentLineFromPosition();
            int offset = 0;
            offset = MarkerBlockProvider.Companion.passSmallIndent$default(MarkerBlockProvider.Companion, (CharSequence)text, 0, 2, null);
            if (offset >= text.length() || text.charAt(offset) != '#') {
                return null;
            }
            int start = offset;
            int n = 6;
            for (int i = 0; i < n; ++i) {
                int it = i;
                boolean bl = false;
                if (offset >= text.length() || text.charAt(offset) != '#') continue;
                ++offset;
            }
            if (offset < text.length() && !CollectionsKt.listOf((Object[])(objectArray = new Character[]{Character.valueOf(' '), Character.valueOf('\t')})).contains(Character.valueOf(text.charAt(offset)))) {
                return null;
            }
            return new IntRange(start, offset - 1);
        }
        return null;
    }
}

