/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.SetextHeaderMarkerBlock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J*\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/SetextHeaderProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "<init>", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "getNextLineFromConstraints", "", "Companion", "jb-md"})
@SourceDebugExtension(value={"SMAP\nSetextHeaderProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetextHeaderProvider.kt\norg/intellij/markdown/parser/markerblocks/providers/SetextHeaderProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class SetextHeaderProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex REGEX = new Regex("^ {0,3}(-+|=+) *$");

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        if (stateInfo.getParagraphBlock() != null) {
            return CollectionsKt.emptyList();
        }
        MarkdownConstraints currentConstaints = stateInfo.getCurrentConstraints();
        if (!Intrinsics.areEqual((Object)stateInfo.getNextConstraints(), (Object)currentConstaints)) {
            return CollectionsKt.emptyList();
        }
        if (MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, currentConstaints)) {
            boolean bl;
            CharSequence charSequence = this.getNextLineFromConstraints(pos, currentConstaints);
            if (charSequence != null) {
                CharSequence it = charSequence;
                boolean bl2 = false;
                bl = REGEX.matches(it);
            } else {
                bl = false;
            }
            if (bl) {
                return CollectionsKt.listOf((Object)new SetextHeaderMarkerBlock(currentConstaints, productionHolder));
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        return false;
    }

    private final CharSequence getNextLineFromConstraints(LookaheadText.Position pos, MarkdownConstraints constraints) {
        String string = pos.getNextLine();
        if (string == null) {
            return null;
        }
        String line = string;
        MarkdownConstraints nextLineConstraints = constraints.applyToNextLine(pos.nextLinePosition());
        if (MarkdownConstraintsKt.extendsPrev(nextLineConstraints, constraints)) {
            return (CharSequence)MarkdownConstraintsKt.eatItselfFromString(nextLineConstraints, line);
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/markdown/parser/markerblocks/providers/SetextHeaderProvider$Companion;", "", "<init>", "()V", "REGEX", "Lkotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;", "jb-md"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getREGEX() {
            return REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

