/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.l.ling.ftp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilter;
import org.apache.commons.net.ftp.FTPReply;
import org.azolla.l.ling.exception.AzollaException;
import org.azolla.l.ling.exception.code.AzollaCode;
import org.azolla.l.ling.io.Close0;
import org.azolla.l.ling.io.File0;
import org.azolla.l.ling.util.KV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Ftp0 {
    private static final Logger LOG = LoggerFactory.getLogger(Ftp0.class);
    public static final int DEFAULT_PORT = 21;
    public static final int DEFAULT_FILE_TYPE = 2;
    public static final int DEFAULT_MODE = 2;
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_BUFFER_SIZE = 100000;
    private static Ftp0 instance = null;
    private String host;
    private String username;
    private String password;
    private int port = 21;
    private int fileType = 2;
    private int mode = 2;
    private int timeout = 3000;
    private int bufferSize = 100000;
    private String encoding = "UTF-8";
    private FTPClient client;

    public static synchronized Ftp0 single(String host, String username, String password) {
        return Ftp0.single(host, username, password, 21);
    }

    public static synchronized Ftp0 single(String host, String username, String password, int port) {
        return Ftp0.single(host, username, password, port, 2);
    }

    public static synchronized Ftp0 single(String host, String username, String password, int port, int fileType) {
        return Ftp0.single(host, username, password, port, fileType, 2);
    }

    public static synchronized Ftp0 single(String host, String username, String password, int port, int fileType, int mode) {
        return Ftp0.single(host, username, password, port, fileType, mode, 3000);
    }

    public static synchronized Ftp0 single(String host, String username, String password, int port, int fileType, int mode, int timeout) {
        return Ftp0.single(host, username, password, port, fileType, mode, timeout, "UTF-8");
    }

    public static synchronized Ftp0 single(String host, String username, String password, int port, int fileType, int mode, int timeout, String encoding) {
        return instance == null ? new Ftp0(host, username, password, port, fileType, mode, timeout, encoding) : instance;
    }

    public Ftp0(String host, String username, String password) {
        this(host, username, password, 21);
    }

    public Ftp0(String host, String username, String password, int port) {
        this(host, username, password, port, 2);
    }

    public Ftp0(String host, String username, String password, int port, int fileType) {
        this(host, username, password, port, fileType, 2);
    }

    public Ftp0(String host, String username, String password, int port, int fileType, int mode) {
        this(host, username, password, port, fileType, mode, 3000);
    }

    public Ftp0(String host, String username, String password, int port, int fileType, int mode, int timeout) {
        this(host, username, password, port, fileType, mode, timeout, "UTF-8");
    }

    public Ftp0(String host, String username, String password, int port, int fileType, int mode, int timeout, String encoding) {
        this.connect(host, username, password, port, fileType, mode, timeout, encoding);
    }

    private FTPClient activeClient() {
        this.disconnect();
        this.connect(this.host, this.username, this.password, this.port, this.fileType, this.mode, this.timeout, this.encoding);
        return this.client;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connect(String host, String username, String password, int port, int fileType, int mode, int timeout, @Nullable String encoding) {
        this.client = new FTPClient();
        this.setEncoding(encoding);
        try {
            this.client.connect(host, port);
            this.setHost(host);
            this.setPort(port);
        }
        catch (Exception e) {
            LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_CONNECT_ERROR, KV.ins("host", host).put("port", port), e});
            throw AzollaException.wrap(e, AzollaCode.FTP_CONNECT_ERROR).set("host", host).set("port", port);
        }
        int code = this.client.getReplyCode();
        if (FTPReply.isPositiveCompletion((int)code)) {
            boolean logined = true;
            try {
                logined = this.client.login(username, password);
            }
            catch (Exception e) {
                LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_LOGIN_ERROR, KV.ins("username", username).put("password", password), e});
                throw AzollaException.wrap(e, AzollaCode.FTP_LOGIN_ERROR).set("username", username).set("password", password);
            }
            if (!logined) {
                LOG.error("[ErrorCode={}][{}]", (Object)AzollaCode.FTP_LOGIN_FAILED, (Object)KV.ins("username", username).put("password", password));
                throw new AzollaException(AzollaCode.FTP_LOGIN_FAILED).set("username", username).set("password", password);
            }
            this.setUsername(username);
            this.setPassword(password);
            this.setFileType(fileType);
            this.setBufferSize(this.bufferSize);
        } else {
            this.disconnect();
        }
        this.setMode(mode);
        this.setFileType(fileType);
        this.setTimeout(timeout);
    }

    public boolean disconnect() {
        boolean rtnBoolean = true;
        if (this.client != null && this.client.isConnected()) {
            try {
                this.client.logout();
            }
            catch (Exception e) {
                LOG.warn("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_LOGOUT_ERROR, KV.ins("host", this.host), e});
                rtnBoolean = false;
            }
        }
        if (this.client != null && this.client.isConnected()) {
            try {
                this.client.disconnect();
            }
            catch (Exception e) {
                LOG.warn("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_DISCONNECT_ERROR, KV.ins("host", this.host), e});
                rtnBoolean = false;
            }
        }
        return rtnBoolean;
    }

    public boolean deleteFile(@Nullable FTPClient client, String remotePath) {
        boolean rtnBoolean = true;
        try {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)remotePath) ? 1 : 0) != 0);
            FTPClient fTPClient = client = client == null ? this.activeClient() : client;
            rtnBoolean = this.isDirectory(client, remotePath) ? this.deleteFile0(client, remotePath) : client.deleteFile(remotePath);
        }
        catch (Exception e) {
            LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_DELETE_FILE_ERROR, KV.ins("remotePath", remotePath), e});
            rtnBoolean = false;
        }
        return rtnBoolean;
    }

    private boolean deleteFile0(FTPClient client, String remotePath) {
        boolean rtnBoolean = true;
        try {
            for (FTPFile file : client.listFiles(remotePath)) {
                String prefix = remotePath + (remotePath.endsWith("/") ? "" : "/");
                if (file.isDirectory()) {
                    rtnBoolean = rtnBoolean && this.deleteFile0(client, prefix + file.getName());
                }
                rtnBoolean = rtnBoolean && client.deleteFile(prefix + file.getName());
            }
            rtnBoolean = rtnBoolean && client.deleteFile(remotePath);
        }
        catch (IOException e) {
            LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_DELETE_FILE_ERROR, KV.ins("remotePath", remotePath), e});
            rtnBoolean = false;
        }
        return rtnBoolean;
    }

    public boolean retrieveFile(@Nullable FTPClient client, String remotePath, File localFile) {
        boolean rtnBoolean;
        block4: {
            rtnBoolean = true;
            try {
                Preconditions.checkNotNull((Object)localFile);
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)remotePath) ? 1 : 0) != 0);
                FTPClient fTPClient = client = client == null ? this.activeClient() : client;
                if (this.isDirectory(client, remotePath) && localFile.isDirectory() || !this.isDirectory(client, remotePath) && !localFile.isDirectory()) {
                    rtnBoolean = this.retrieveFile0(client, remotePath, localFile);
                    break block4;
                }
                if (this.isExist(client, remotePath) && !this.isDirectory(client, remotePath) && localFile.isDirectory()) {
                    File file = File0.newFile(localFile, this.listFiles(client, remotePath, null).get(0).getName());
                    rtnBoolean = file.createNewFile() && this.retrieveFile0(client, remotePath, file);
                    break block4;
                }
                throw new IllegalArgumentException();
            }
            catch (Exception e) {
                LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_RETRIEVE_FILE_ERROR, KV.ins("remotePath", remotePath).put("localFile", localFile), e});
                rtnBoolean = false;
            }
        }
        return rtnBoolean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retrieveFile0(FTPClient client, String remotePath, File localFile) {
        FileOutputStream os;
        BufferedOutputStream bos;
        boolean rtnBoolean;
        block6: {
            rtnBoolean = true;
            bos = null;
            os = null;
            try {
                if (this.isDirectory(client, remotePath) && localFile.isDirectory()) {
                    String prefix = remotePath + (remotePath.endsWith("/") ? "" : "/");
                    for (FTPFile file : client.listFiles(remotePath)) {
                        String newPath = prefix + file.getName();
                        File newFile = File0.newFile(localFile, file.getName());
                        rtnBoolean = rtnBoolean && file.isDirectory() ? newFile.mkdirs() : newFile.createNewFile();
                        rtnBoolean = rtnBoolean && this.retrieveFile0(client, newPath, newFile);
                    }
                    break block6;
                }
                os = new FileOutputStream(localFile);
                bos = new BufferedOutputStream(os);
                rtnBoolean = rtnBoolean && client.retrieveFile(remotePath, (OutputStream)bos);
            }
            catch (Exception e) {
                try {
                    LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_RETRIEVE_FILE_ERROR, KV.ins("remotePath", remotePath).put("localFile", localFile), e});
                    rtnBoolean = false;
                }
                catch (Throwable throwable) {
                    Close0.close(os);
                    Close0.close(bos);
                    throw throwable;
                }
                Close0.close(os);
                Close0.close(bos);
            }
        }
        Close0.close(os);
        Close0.close(bos);
        return rtnBoolean;
    }

    public boolean isExist(@Nullable FTPClient client, @Nullable String remotePath) {
        boolean rtnBoolean = false;
        try {
            client = client == null ? this.activeClient() : client;
            String[] pathArray = client.listNames(remotePath);
            rtnBoolean = pathArray != null && pathArray.length > 0 ? true : this.isDirectory0(client, remotePath);
        }
        catch (Exception e) {
            LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_LIST_FILE_ERROR, KV.ins("remotePath", remotePath), e});
            rtnBoolean = false;
        }
        return rtnBoolean;
    }

    public boolean isDirectory(@Nullable FTPClient client, @Nullable String remotePath) {
        boolean rtnBoolean = false;
        try {
            FTPClient fTPClient = client = client == null ? this.activeClient() : client;
            if (this.isExist(client, remotePath)) {
                rtnBoolean = this.isDirectory0(client, remotePath);
            }
        }
        catch (Exception e) {
            LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_LIST_FILE_ERROR, KV.ins("remotePath", remotePath), e});
            rtnBoolean = false;
        }
        return rtnBoolean;
    }

    private boolean isDirectory0(FTPClient client, String remotePath) {
        boolean rtnBoolean;
        block4: {
            rtnBoolean = false;
            try {
                if (Strings.isNullOrEmpty((String)remotePath) && "/".equalsIgnoreCase(remotePath)) {
                    rtnBoolean = true;
                    break block4;
                }
                remotePath = (remotePath.startsWith("/") ? "" : "/") + remotePath;
                remotePath = remotePath + (remotePath.endsWith("/") ? "" : "/");
                String[] nameArray = remotePath.split("/");
                FTPFile[] array = client.listFiles("/" + Joiner.on((String)"/").join((Object[])Arrays.copyOfRange(nameArray, 1, nameArray.length - 1)));
                if (array == null || array.length <= 0) break block4;
                for (FTPFile file : array) {
                    if (!file.isDirectory() || !file.getName().equals(nameArray[nameArray.length - 1])) continue;
                    rtnBoolean = true;
                    break;
                }
            }
            catch (Exception e) {
                LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_LIST_FILE_ERROR, KV.ins("remotePath", remotePath), e});
                rtnBoolean = false;
            }
        }
        return rtnBoolean;
    }

    public List<String> listNames(@Nullable FTPClient client, @Nullable String remotePath) {
        ArrayList rtnList = Lists.newArrayList();
        try {
            client = client == null ? this.activeClient() : client;
            Object[] pathArray = client.listNames(remotePath);
            rtnList = pathArray == null ? rtnList : Lists.newArrayList((Object[])pathArray);
        }
        catch (Exception e) {
            LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_LIST_FILE_ERROR, KV.ins("remotePath", remotePath), e});
        }
        return rtnList;
    }

    public List<String> allNames(@Nullable FTPClient client, @Nullable String remotePath, @Nullable FTPFileFilter filter) {
        ArrayList rtnList = Lists.newArrayList();
        try {
            FTPFile[] pathArray;
            client = client == null ? this.activeClient() : client;
            FTPFile[] fTPFileArray = pathArray = filter == null ? client.listFiles(remotePath) : client.listFiles(remotePath, filter);
            if (pathArray != null && pathArray.length > 0) {
                String filePrefix = Strings.isNullOrEmpty((String)remotePath) ? "" : (remotePath.startsWith("/") ? remotePath : "/" + remotePath);
                String folderPrefix = filePrefix.endsWith("/") ? filePrefix : filePrefix + "/";
                for (FTPFile f : pathArray) {
                    if (f.isDirectory()) {
                        rtnList.addAll(this.allNames(client, folderPrefix + f.getName(), filter));
                    }
                    if (pathArray.length > 1) {
                        rtnList.add(folderPrefix + f.getName());
                        continue;
                    }
                    int index = filePrefix.lastIndexOf("/");
                    rtnList.add(f.getName().equals(-1 == index ? filePrefix : filePrefix.substring(index + 1)) ? filePrefix : filePrefix + "/" + f.getName());
                }
            }
        }
        catch (Exception e) {
            LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_LIST_FILE_ERROR, KV.ins("remotePath", remotePath), e});
        }
        return rtnList;
    }

    public List<FTPFile> listFiles(@Nullable FTPClient client, @Nullable String remotePath, @Nullable FTPFileFilter filter) {
        ArrayList rtnList = Lists.newArrayList();
        try {
            client = client == null ? this.activeClient() : client;
            Object[] pathArray = filter == null ? client.listFiles(remotePath) : client.listFiles(remotePath, filter);
            rtnList = pathArray == null ? rtnList : Lists.newArrayList((Object[])pathArray);
        }
        catch (Exception e) {
            LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_LIST_FILE_ERROR, KV.ins("remotePath", remotePath), e});
        }
        return rtnList;
    }

    public boolean storeFile(@Nullable FTPClient client, String remotePath, File localFile) {
        boolean rtnBoolean = false;
        try {
            Preconditions.checkNotNull((Object)localFile);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)remotePath) ? 1 : 0) != 0);
            FTPClient fTPClient = client = client == null ? this.activeClient() : client;
            if (this.isDirectory(client, remotePath) && localFile.isDirectory() || !this.isDirectory(client, remotePath) && !localFile.isDirectory()) {
                rtnBoolean = this.storeFile0(client, remotePath, localFile);
            } else if (this.isDirectory(client, remotePath) && localFile.exists() && !localFile.isDirectory()) {
                String prefix = remotePath + (remotePath.endsWith("/") ? "" : "/");
                rtnBoolean = this.storeFile0(client, prefix + localFile.getName(), localFile);
            }
        }
        catch (Exception e) {
            LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_STORE_FILE_ERROR, KV.ins("remotePath", remotePath).put("localPath", localFile), e});
            rtnBoolean = false;
        }
        return rtnBoolean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeFile0(FTPClient client, String remotePath, File localFile) {
        FileInputStream is;
        BufferedInputStream bis;
        boolean rtnBoolean;
        block6: {
            rtnBoolean = true;
            bis = null;
            is = null;
            try {
                if (this.isDirectory(client, remotePath) && localFile.isDirectory()) {
                    String prefix = remotePath + (remotePath.endsWith("/") ? "" : "/");
                    for (File newFile : localFile.listFiles()) {
                        String newPath = prefix + newFile.getName();
                        rtnBoolean = rtnBoolean && newFile.isDirectory() ? client.makeDirectory(newPath) : true;
                        rtnBoolean = rtnBoolean && this.storeFile0(client, newPath, newFile);
                    }
                    break block6;
                }
                is = new FileInputStream(localFile);
                bis = new BufferedInputStream(is);
                rtnBoolean = rtnBoolean && client.storeFile(remotePath, (InputStream)bis);
            }
            catch (Exception e) {
                try {
                    LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_RETRIEVE_FILE_ERROR, KV.ins("remotePath", remotePath).put("localFile", localFile), e});
                    rtnBoolean = false;
                }
                catch (Throwable throwable) {
                    Close0.close(is);
                    Close0.close(bis);
                    throw throwable;
                }
                Close0.close(is);
                Close0.close(bis);
            }
        }
        Close0.close(is);
        Close0.close(bis);
        return rtnBoolean;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getFileType() {
        return this.fileType;
    }

    public Ftp0 setFileType(int fileType) {
        try {
            this.client.setFileType(fileType);
            this.fileType = fileType;
        }
        catch (Exception e) {
            LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_SET_FILETYPE_ERROR, KV.ins("fileType", fileType), e});
            throw AzollaException.wrap(e, AzollaCode.FTP_SET_FILETYPE_ERROR).set("fileType", fileType);
        }
        return this;
    }

    public int getMode() {
        return this.mode;
    }

    public Ftp0 setMode(int mode) {
        boolean successed = true;
        switch (mode) {
            case 2: {
                this.client.enterLocalPassiveMode();
                break;
            }
            case 0: {
                this.client.enterLocalActiveMode();
                break;
            }
            case 3: {
                try {
                    successed = this.client.enterRemotePassiveMode();
                    break;
                }
                catch (Exception e) {
                    successed = false;
                    LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_SET_MODE_ERROR, KV.ins("mode", mode), e});
                    throw AzollaException.wrap(e, AzollaCode.FTP_SET_MODE_ERROR).set("mode", mode);
                }
            }
            case 1: {
                try {
                    successed = this.client.enterRemoteActiveMode(InetAddress.getByName(this.host), this.port);
                    break;
                }
                catch (Exception e) {
                    successed = false;
                    LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_SET_MODE_ERROR, KV.ins("mode", mode), e});
                    throw AzollaException.wrap(e, AzollaCode.FTP_SET_MODE_ERROR).set("mode", mode);
                }
            }
            default: {
                throw new AzollaException(AzollaCode.FTP_SET_MODE_FAILED).set("mode", mode);
            }
        }
        if (successed) {
            this.mode = mode;
        }
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Ftp0 setEncoding(@Nullable String encoding) {
        encoding = Strings.isNullOrEmpty((String)encoding) ? "UTF-8" : encoding;
        this.client.setControlEncoding(encoding);
        this.encoding = encoding;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Ftp0 setTimeout(int timeout) {
        try {
            this.client.setSoTimeout(timeout);
            this.timeout = timeout;
        }
        catch (Exception e) {
            LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.FTP_SET_TIMEOUT_ERROR, KV.ins("timeout", timeout), e});
            throw AzollaException.wrap(e, AzollaCode.FTP_SET_TIMEOUT_ERROR).set("timeout", timeout);
        }
        return this;
    }

    public FTPClient getClient() {
        return this.client;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.client.setBufferSize(bufferSize);
        this.bufferSize = bufferSize;
    }
}

