/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.l.ling.cfg;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.azolla.l.ling.util.KV;
import org.azolla.l.ling.util.Log0;

public final class Cfg0 {
    private static final LoadingCache<Class<?>, JAXBContext> CACHE = CacheBuilder.newBuilder().softValues().build((CacheLoader)ConfigLoader.single());

    private static JAXBContext getJAXBContext(Class<?> clazz) throws ExecutionException {
        return (JAXBContext)CACHE.get(clazz);
    }

    public static <T> T unmarshal(Class<T> clazz, File file) {
        Object rtnT = null;
        try {
            rtnT = Cfg0.getJAXBContext(clazz).createUnmarshaller().unmarshal(file);
        }
        catch (Exception e) {
            Log0.error(Cfg0.class, "[{}]", KV.ins("clazz", clazz).put("filePath", file), e);
            rtnT = null;
        }
        return (T)rtnT;
    }

    public static <T> boolean marshal(T t, File file) {
        return Cfg0.marshal(t, file, "UTF-8");
    }

    public static <T> boolean marshal(T t, File file, @Nullable String encoding) {
        boolean rtnBoolean = true;
        encoding = Strings.isNullOrEmpty((String)encoding) ? "UTF-8" : encoding;
        try {
            Marshaller m = Cfg0.getJAXBContext(t.getClass()).createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setProperty("jaxb.encoding", (Object)encoding);
            m.marshal(t, file);
        }
        catch (Exception e) {
            Log0.error(Cfg0.class, "[{}]", KV.ins("t", t).put("file", file).put("encoding", encoding), e);
            rtnBoolean = false;
        }
        return rtnBoolean;
    }

    private static class ConfigLoader
    extends CacheLoader<Class<?>, JAXBContext> {
        private static ConfigLoader instance;

        private ConfigLoader() {
        }

        public static ConfigLoader single() {
            return null == instance ? new ConfigLoader() : instance;
        }

        public JAXBContext load(Class<?> key) throws Exception {
            return JAXBContext.newInstance((Class[])new Class[]{key});
        }
    }
}

