/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.l.ling.exception;

import com.google.common.collect.Maps;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import javax.annotation.Nullable;
import org.azolla.l.ling.exception.code.AzollaCode;
import org.azolla.l.ling.exception.code.ErrorCoder;

public class AzollaException
extends RuntimeException {
    private static final long serialVersionUID = 6975777768178330101L;
    private ErrorCoder errorCode;
    private final Map<String, Object> properties = Maps.newTreeMap();

    public AzollaException(ErrorCoder errorCode) {
        this.setErrorCode(errorCode);
    }

    public AzollaException(ErrorCoder errorCode, String message) {
        super(message);
        this.setErrorCode(errorCode);
    }

    public AzollaException(ErrorCoder errorCode, Throwable cause) {
        super(cause);
        this.setErrorCode(errorCode);
    }

    public AzollaException(ErrorCoder errorCode, String message, Throwable cause) {
        super(message, cause);
        this.setErrorCode(errorCode);
    }

    public static AzollaException wrap(Throwable cause) {
        return AzollaException.wrap(cause, AzollaCode.UNAZOLLA);
    }

    public static AzollaException wrap(Throwable cause, ErrorCoder errorCode) {
        if (cause instanceof AzollaException) {
            AzollaException se = (AzollaException)cause;
            ErrorCoder currentErrorCoder = se.getErrorCode();
            return errorCode != currentErrorCoder ? new AzollaException(errorCode, cause) : se;
        }
        return new AzollaException(errorCode, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.println(this);
            s.println();
            s.println("\t--------Azolla Exception Properties--------");
            if (this.errorCode != null) {
                s.println("\t" + this.errorCode + ":" + this.errorCode.getClass().getName());
            }
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                s.println("\t" + entry.getKey() + "=[" + entry.getValue() + "]");
            }
            s.println("\t-------------------------------------------");
            s.println();
            StackTraceElement[] trace = this.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                s.println("\tat " + trace[i]);
            }
            Throwable ourCause = this.getCause();
            if (ourCause != null) {
                ourCause.printStackTrace(s);
            }
            s.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.println(this);
            s.println();
            s.println("\t--------Azolla Exception Properties--------");
            if (this.errorCode != null) {
                s.println("\t" + this.errorCode + ":" + this.errorCode.getClass().getName());
            }
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                s.println("\t" + entry.getKey() + "=[" + entry.getValue() + "]");
            }
            s.println("\t-------------------------------------------");
            s.println();
            StackTraceElement[] trace = this.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                s.println("\tat " + trace[i]);
            }
            Throwable ourCause = this.getCause();
            if (ourCause != null) {
                ourCause.printStackTrace(s);
            }
            s.flush();
        }
    }

    public Object get(String key) {
        return this.properties.get(key);
    }

    public AzollaException set(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public ErrorCoder getErrorCode() {
        this.errorCode = null == this.errorCode ? AzollaCode.UNAZOLLA : this.errorCode;
        return this.errorCode;
    }

    public void setErrorCode(@Nullable ErrorCoder errorCode) {
        this.errorCode = null == errorCode ? AzollaCode.UNAZOLLA : errorCode;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

