/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.l.ling.zip;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.azolla.l.ling.exception.code.AzollaCode;
import org.azolla.l.ling.io.Close0;
import org.azolla.l.ling.io.File0;
import org.azolla.l.ling.lang.String0;
import org.azolla.l.ling.util.Date0;
import org.azolla.l.ling.util.KV;
import org.azolla.l.ling.util.Log0;

public final class Zip0 {
    private static int bufSize = 8096;

    public static boolean unzip(File zipFile) {
        return Zip0.unzip(zipFile, null);
    }

    public static boolean unzip(File zipFile, @Nullable String dest) {
        return Zip0.unzip(zipFile, dest, null);
    }

    public static boolean unzip(File zipFile, @Nullable String dest, @Nullable String encoding) {
        boolean rtnBoolean = true;
        if (zipFile != null) {
            dest = Strings.isNullOrEmpty((String)dest) ? zipFile.getParent() : dest;
            encoding = Strings.isNullOrEmpty((String)encoding) ? "UTF-8" : encoding;
            File destFile = null;
            ZipFile zf = null;
            try {
                zf = new ZipFile(zipFile, encoding);
                Enumeration entries = zf.getEntries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = (ZipEntry)entries.nextElement();
                    destFile = new File(dest, entry.getName());
                    Zip0.unzipFile(destFile, zf, entry);
                }
            }
            catch (Exception e) {
                rtnBoolean = false;
                Log0.error(Zip0.class, "[ErrorCode={}][{}]\n{}", AzollaCode.ZIP_ZIP_ERROR, KV.ins("zipFile", zipFile).put("dest", dest).put("encoding", encoding), e);
            }
        }
        return rtnBoolean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean unzipFile(File destFile, ZipFile zipFile, ZipEntry entry) {
        boolean rtnBoolean = true;
        if (entry.isDirectory()) {
            destFile.mkdirs();
            return rtnBoolean;
        }
        File parent = destFile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            int readedBytes;
            is = zipFile.getInputStream(entry);
            fos = new FileOutputStream(destFile);
            byte[] buf = new byte[bufSize];
            while ((readedBytes = is.read(buf)) > 0) {
                fos.write(buf, 0, readedBytes);
            }
        }
        catch (Exception e) {
            try {
                rtnBoolean = false;
                Log0.error(Zip0.class, "[ErrorCode={}][{}]\n{}", AzollaCode.ZIP_ZIP_ERROR, KV.ins("destFile", destFile), e);
            }
            catch (Throwable throwable) {
                Close0.close(fos);
                Close0.close(is);
                throw throwable;
            }
            Close0.close(fos);
            Close0.close(is);
            return rtnBoolean;
        }
        Close0.close(fos);
        Close0.close(is);
        return rtnBoolean;
    }

    public static boolean zip(File dirFile) {
        return Zip0.zip(dirFile, false);
    }

    public static boolean zip(File dirFile, boolean self) {
        return dirFile == null ? false : Zip0.zip(dirFile, dirFile.getPath(), self);
    }

    public static boolean zip(File dirFile, @Nullable String encoding) {
        return dirFile == null ? false : Zip0.zip(dirFile, dirFile.getPath(), encoding);
    }

    public static boolean zip(File dirFile, String zip, boolean self) {
        return Zip0.zip(dirFile, zip, null, self);
    }

    public static boolean zip(File dirFile, String zip, @Nullable String encoding) {
        return Zip0.zip(dirFile, zip, encoding, false);
    }

    public static boolean zip(File dirFile, String zip, @Nullable String encoding, boolean self) {
        boolean rtnBoolean = false;
        if (dirFile != null) {
            ArrayList fileList = Lists.newArrayList();
            if (self || dirFile.isFile()) {
                fileList.add(dirFile);
            } else {
                fileList.addAll(Lists.newArrayList((Object[])dirFile.listFiles()));
            }
            rtnBoolean = Zip0.zip(fileList, zip, encoding);
        }
        return rtnBoolean;
    }

    public static boolean zip(List<File> fileList) {
        return Zip0.zip(fileList, null);
    }

    public static boolean zip(List<File> fileList, @Nullable String zip) {
        return Zip0.zip(fileList, zip, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zip(List<File> fileList, @Nullable String zip, @Nullable String encoding) {
        boolean rtnBoolean = false;
        if (null != fileList) {
            encoding = Strings.isNullOrEmpty((String)encoding) ? "UTF-8" : encoding;
            String string = zip = Strings.isNullOrEmpty((String)zip) ? Date0.toString("yyyy_MM_dd_HH_mm_ss") : zip;
            if (!Lists.newArrayList((Object[])new String[]{"zip", "jar", "war"}).contains(File0.fileType(zip).toLowerCase())) {
                zip = zip + String0.POINT + "zip";
            }
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            ZipOutputStream zos = null;
            try {
                fos = new FileOutputStream(zip);
                bos = new BufferedOutputStream(fos);
                zos = new ZipOutputStream((OutputStream)bos);
                zos.setEncoding(encoding);
                for (File file : fileList) {
                    Zip0.zipFiles(file, zos, "");
                }
                rtnBoolean = true;
            }
            catch (Exception e) {
                try {
                    rtnBoolean = false;
                    Log0.error(Zip0.class, "[ErrorCode={}][{}]\n{}", AzollaCode.ZIP_ZIP_ERROR, KV.ins("fileList", Joiner.on((String)"|").join(fileList)).put("zip", zip).put("encoding", encoding), e);
                }
                catch (Throwable throwable) {
                    Close0.close(zos);
                    Close0.close(bos);
                    Close0.close(fos);
                    throw throwable;
                }
                Close0.close((Closeable)zos);
                Close0.close(bos);
                Close0.close(fos);
            }
            Close0.close((Closeable)zos);
            Close0.close(bos);
            Close0.close(fos);
        }
        return rtnBoolean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean zipFiles(File file, ZipOutputStream zipOutput, String pathName) {
        BufferedInputStream bis;
        FileInputStream fis;
        boolean rtnBoolean;
        block8: {
            rtnBoolean = true;
            fis = null;
            bis = null;
            try {
                int len;
                String fileName = pathName + file.getName();
                if (file.isDirectory()) {
                    fileName = fileName + String0.SLASH;
                    zipOutput.putNextEntry(new ZipEntry(fileName));
                    String[] fileNames = file.list();
                    if (fileNames != null) {
                        for (int i = 0; i < fileNames.length; ++i) {
                            Zip0.zipFiles(new File(file, fileNames[i]), zipOutput, fileName);
                        }
                    }
                    break block8;
                }
                ZipEntry jarEntry = new ZipEntry(fileName);
                zipOutput.putNextEntry(jarEntry);
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                byte[] buf = new byte[bufSize];
                while ((len = bis.read(buf)) >= 0) {
                    zipOutput.write(buf, 0, len);
                }
                zipOutput.closeEntry();
            }
            catch (Exception e) {
                try {
                    rtnBoolean = false;
                    Log0.error(Zip0.class, "[ErrorCode={}][{}]\n{}", AzollaCode.ZIP_ZIP_ERROR, KV.ins("file", file).put("pathName", pathName), e);
                }
                catch (Throwable throwable) {
                    Close0.close(bis);
                    Close0.close(fis);
                    throw throwable;
                }
                Close0.close(bis);
                Close0.close(fis);
            }
        }
        Close0.close(bis);
        Close0.close(fis);
        return rtnBoolean;
    }
}

