/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.l.ling.io;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import javax.annotation.Nullable;
import org.azolla.l.ling.io.Close0;
import org.azolla.l.ling.io.Encode0;
import org.azolla.l.ling.lang.String0;
import org.azolla.l.ling.util.KV;
import org.azolla.l.ling.util.Log0;

public final class File0 {
    public static final String ILLEGAL_FILENAME_REGEX = "[{/\\\\:*?\"<>|}]";
    public static final String MD5 = "MD5";
    public static final String CRC32 = "CRC32";
    public static final String USER_DIR = "user.dir";
    public static final String USER_HOME = "user.home";
    public static final String ZIP_FILETYPE = "zip";
    public static final String JAR_FILETYPE = "jar";
    public static final String WAR_FILETYPE = "war";
    public static final String TXT_FILETYPE = "txt";
    public static final String BAK_FILETYPE = "bak";
    public static final String PNG_FILETYPE = "png";
    public static final String PROP_FILETYPE = "properties";
    public static final String XML_FILETYPE = "xml";
    public static final int BUFFER_SIZE = 262144;

    public static File newFile(String ... strings) {
        return new File(Joiner.on((String)File.separator).join((Object[])strings));
    }

    public static File newFile(File parent, String ... strings) {
        return new File(parent, Joiner.on((String)File.separator).join((Object[])strings));
    }

    public static boolean delFile(File file) {
        boolean rtnBoolean = true;
        if (null != file && file.exists()) {
            rtnBoolean = File0.delFile0(file);
        }
        return rtnBoolean;
    }

    private static boolean delFile0(File file) {
        boolean rtnBoolean = true;
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                rtnBoolean = rtnBoolean && File0.delFile0(subFile);
            }
        }
        rtnBoolean = rtnBoolean && file.delete();
        return rtnBoolean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean emptyFile(File file) {
        boolean rtnBoolean = true;
        if (null == file) return rtnBoolean;
        if (!file.exists()) return rtnBoolean;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                rtnBoolean = rtnBoolean && File0.delFile0(subFile);
                ++n2;
            }
            return rtnBoolean;
        }
        File bakFile = File0.bakFileName(file);
        if (!rtnBoolean) return false;
        if (!file.renameTo(bakFile)) return false;
        boolean bl = true;
        rtnBoolean = bl;
        if (!rtnBoolean) return rtnBoolean;
        try {
            if (!rtnBoolean) return false;
            if (!file.createNewFile()) return false;
            boolean bl2 = true;
            rtnBoolean = bl2;
            if (!rtnBoolean) return rtnBoolean;
            bakFile.delete();
            return rtnBoolean;
        }
        catch (Exception e) {
            Log0.error(File0.class, "[{}]", KV.ins("file", file), e);
            bakFile.renameTo(file);
            return false;
        }
    }

    public static File bakFileName(File file) {
        File rtnFile = null;
        if (null != file) {
            rtnFile = File0.newFile(file.getParentFile(), file.getName() + String0.POINT + BAK_FILETYPE);
        }
        return rtnFile;
    }

    public static List<File> allFile(File file) {
        return File0.allFile(file, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        });
    }

    public static List<File> allFile(File file, FileFilter fileFilter) {
        ArrayList rtnList = Lists.newArrayList();
        if (null != file && file.exists() && fileFilter != null) {
            rtnList.addAll(File0.allFile0(file, fileFilter));
        }
        return rtnList;
    }

    private static List<File> allFile0(File file, FileFilter fileFilter) {
        ArrayList rtnList = Lists.newArrayList();
        if (fileFilter != null && fileFilter.accept(file)) {
            rtnList.add(file);
        }
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                rtnList.addAll(File0.allFile0(subFile, fileFilter));
            }
        }
        return rtnList;
    }

    public static String fileType(File file) {
        if (null == file) {
            return String.valueOf(file);
        }
        return File0.fileType(file.getName());
    }

    public static String fileType(String fileName) {
        int lastPointIndex = (fileName = String.valueOf(fileName)).lastIndexOf(String0.POINT);
        return -1 == lastPointIndex ? fileName : fileName.substring(lastPointIndex + 1);
    }

    public static String fileNameWithoutFileType(File file) {
        if (null == file) {
            return String.valueOf(file);
        }
        return File0.fileNameWithoutFileType(file.getName());
    }

    public static String fileNameWithoutFileType(String fileName) {
        int lastPointIndex = (fileName = String.valueOf(fileName)).lastIndexOf(String0.POINT);
        return -1 == lastPointIndex ? fileName : fileName.substring(0, lastPointIndex);
    }

    public static String toLegalFileName(String fileName) {
        return File0.toLegalFileName(fileName, String0.UNDERLINE);
    }

    public static String toLegalFileName(String fileName, @Nullable String legalString) {
        fileName = String.valueOf(fileName);
        legalString = Strings.isNullOrEmpty((String)legalString) ? String0.UNDERLINE : legalString;
        return fileName.replaceAll(ILLEGAL_FILENAME_REGEX, legalString);
    }

    public static boolean copy(File from, File to) {
        if (from == null || to == null || !from.exists()) {
            return false;
        }
        return File0.copy0(from, to);
    }

    private static boolean copy0(File from, File to) {
        boolean rtnBoolean = true;
        if (from.isDirectory()) {
            to.mkdirs();
            for (File f : from.listFiles()) {
                rtnBoolean = rtnBoolean && File0.copy0(f, File0.newFile(to, f.getName()));
            }
        } else {
            try {
                com.google.common.io.Files.copy((File)from, (File)to);
            }
            catch (Exception e) {
                Log0.error(File0.class, "[{}]", KV.ins("from", from).put("to", to), e);
                rtnBoolean = false;
            }
        }
        return rtnBoolean;
    }

    public static String getUserDir() {
        return System.getProperty(USER_DIR);
    }

    public static String getUserHome() {
        return System.getProperty(USER_HOME);
    }

    public static String getEncoding(String filePath) {
        try {
            return Files.probeContentType(Paths.get(filePath, new String[0]));
        }
        catch (IOException e) {
            return Encode0.SINGLETON.getFileEncoding(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(File file) {
        String rtnString = null;
        if (file != null && file.isFile()) {
            MessageDigest digest = null;
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            byte[] buffer = new byte[262144];
            try {
                int len;
                digest = MessageDigest.getInstance(MD5);
                fileInputStream = new FileInputStream(file);
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                while ((len = bufferedInputStream.read(buffer, 0, 262144)) != -1) {
                    digest.update(buffer, 0, len);
                }
                rtnString = new BigInteger(1, digest.digest()).toString(16);
            }
            catch (Exception e) {
                try {
                    Log0.error(File0.class, "[{}]", KV.ins("file", file), e);
                }
                catch (Throwable throwable) {
                    Close0.close(bufferedInputStream);
                    Close0.close(fileInputStream);
                    throw throwable;
                }
                Close0.close(bufferedInputStream);
                Close0.close(fileInputStream);
            }
            Close0.close(bufferedInputStream);
            Close0.close(fileInputStream);
        }
        return rtnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCRC32(File file) {
        String rtnString = null;
        if (file != null && file.isFile()) {
            CRC32 crc32 = null;
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            byte[] buffer = new byte[262144];
            try {
                int len;
                crc32 = new CRC32();
                fileInputStream = new FileInputStream(file);
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                while ((len = bufferedInputStream.read(buffer, 0, 262144)) != -1) {
                    crc32.update(buffer, 0, len);
                }
                Long.toHexString(crc32.getValue()).toUpperCase();
            }
            catch (Exception e) {
                Log0.debug(File0.class, "[{}]", KV.ins("file", file), e);
            }
            rtnString = String.valueOf(crc32.getValue());
        }
        return rtnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVer(File file) {
        int subOff;
        int infoOff;
        int infoVirt;
        byte[] buffer;
        RandomAccessFile raf;
        String rtnString;
        block17: {
            block16: {
                String str;
                block15: {
                    block14: {
                        int peOffset;
                        block13: {
                            block12: {
                                rtnString = "";
                                raf = null;
                                raf = new RandomAccessFile(file, "r");
                                buffer = new byte[64];
                                raf.read(buffer);
                                str = "" + (char)buffer[0] + (char)buffer[1];
                                if ("MZ".equals(str)) break block12;
                                String string = rtnString;
                                Close0.close(raf);
                                return string;
                            }
                            peOffset = File0.unpack(new byte[]{buffer[60], buffer[61], buffer[62], buffer[63]});
                            if (peOffset >= 64) break block13;
                            String string = rtnString;
                            Close0.close(raf);
                            return string;
                        }
                        raf.seek(peOffset);
                        buffer = new byte[24];
                        raf.read(buffer);
                        str = "" + (char)buffer[0] + (char)buffer[1];
                        if ("PE".equals(str)) break block14;
                        String string = rtnString;
                        Close0.close(raf);
                        return string;
                    }
                    int machine = File0.unpack(new byte[]{buffer[4], buffer[5]});
                    if (machine == 332) break block15;
                    String string = rtnString;
                    Close0.close(raf);
                    return string;
                }
                int noSections = File0.unpack(new byte[]{buffer[6], buffer[7]});
                int optHdrSize = File0.unpack(new byte[]{buffer[20], buffer[21]});
                raf.seek(raf.getFilePointer() + (long)optHdrSize);
                boolean resFound = false;
                for (int i = 0; i < noSections; ++i) {
                    buffer = new byte[40];
                    raf.read(buffer);
                    str = "" + (char)buffer[0] + (char)buffer[1] + (char)buffer[2] + (char)buffer[3] + (char)buffer[4];
                    if (!".rsrc".equals(str)) continue;
                    resFound = true;
                    break;
                }
                if (resFound) break block16;
                String i = rtnString;
                Close0.close(raf);
                return i;
            }
            infoVirt = File0.unpack(new byte[]{buffer[12], buffer[13], buffer[14], buffer[15]});
            int infoSize = File0.unpack(new byte[]{buffer[16], buffer[17], buffer[18], buffer[19]});
            infoOff = File0.unpack(new byte[]{buffer[20], buffer[21], buffer[22], buffer[23]});
            raf.seek(infoOff);
            buffer = new byte[infoSize];
            raf.read(buffer);
            int nameEntries = File0.unpack(new byte[]{buffer[12], buffer[13]});
            int idEntries = File0.unpack(new byte[]{buffer[14], buffer[15]});
            boolean infoFound = false;
            subOff = 0;
            for (int i = 0; i < nameEntries + idEntries; ++i) {
                int type = File0.unpack(new byte[]{buffer[i * 8 + 16], buffer[i * 8 + 17], buffer[i * 8 + 18], buffer[i * 8 + 19]});
                if (type != 16) continue;
                infoFound = true;
                subOff = File0.unpack(new byte[]{buffer[i * 8 + 20], buffer[i * 8 + 21], buffer[i * 8 + 22], buffer[i * 8 + 23]});
                break;
            }
            if (infoFound) break block17;
            String i = rtnString;
            Close0.close(raf);
            return i;
        }
        try {
            infoOff = File0.unpack(new byte[]{buffer[(subOff &= Integer.MAX_VALUE) + 20], buffer[subOff + 21], buffer[subOff + 22], buffer[subOff + 23]});
            infoOff = File0.unpack(new byte[]{buffer[(infoOff &= Integer.MAX_VALUE) + 20], buffer[infoOff + 21], buffer[infoOff + 22], buffer[infoOff + 23]});
            int dataOff = File0.unpack(new byte[]{buffer[infoOff], buffer[infoOff + 1], buffer[infoOff + 2], buffer[infoOff + 3]});
            int version1 = File0.unpack(new byte[]{buffer[(dataOff -= infoVirt) + 48], buffer[dataOff + 48 + 1]});
            int version2 = File0.unpack(new byte[]{buffer[dataOff + 48 + 2], buffer[dataOff + 48 + 3]});
            int version3 = File0.unpack(new byte[]{buffer[dataOff + 48 + 4], buffer[dataOff + 48 + 5]});
            int version4 = File0.unpack(new byte[]{buffer[dataOff + 48 + 6], buffer[dataOff + 48 + 7]});
            rtnString = version2 + String0.POINT + version1 + String0.POINT + version4 + String0.POINT + version3;
        }
        catch (Exception e) {
            try {
                Log0.error(File0.class, "[{}]", KV.ins("file", file), e);
            }
            catch (Throwable throwable) {
                Close0.close(raf);
                throw throwable;
            }
            Close0.close(raf);
        }
        Close0.close(raf);
        return rtnString;
    }

    private static int unpack(byte[] b) {
        int num = 0;
        for (int i = 0; i < b.length; ++i) {
            num = 256 * num + (b[b.length - 1 - i] & 0xFF);
        }
        return num;
    }

    public static void main(String[] args) {
        String s1 = "";
        System.out.println(new File(s1).getAbsolutePath());
        List stringList = null;
        for (String s : stringList) {
            System.out.println(s);
        }
    }
}

