/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.l.ling.cfg;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URL;
import javax.annotation.Nonnull;
import org.azolla.l.ling.net.Url0;

public interface LibCfg {
    public static final String REGULAR_CFG_FILENAME = "^(.)*\\.Azolla.Cfg\\.(properties|xml)$";
    public static final LoadingCache<String, URL> cfgFileCacheBuilder = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, URL>(){

        public URL load(@Nonnull String pathStartWithSlash) throws Exception {
            if (pathStartWithSlash.matches(LibCfg.REGULAR_CFG_FILENAME)) {
                return Url0.getURL(pathStartWithSlash);
            }
            throw new Exception("{" + pathStartWithSlash + "} is not Azolla.org config.");
        }
    });

    default public void refresh(String pathStartWithSlash) {
        cfgFileCacheBuilder.refresh((Object)pathStartWithSlash);
    }

    public void refresh();
}

