/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.l.ling.cfg;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.azolla.l.ling.cfg.LibCfg;
import org.azolla.l.ling.io.Close0;
import org.azolla.l.ling.util.KV;
import org.azolla.l.ling.util.Log0;

public class PropCfg
implements LibCfg {
    private String pathStartWithSlash = null;
    private Properties prop = new Properties();
    private LoadingCache<String, String> cfgCacheBuilder = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

        public String load(@Nonnull String key) throws Exception {
            return PropCfg.this.prop.getProperty(key);
        }
    });

    private PropCfg(@Nonnull String pathStartWithSlash) {
        this.pathStartWithSlash = pathStartWithSlash;
        this.refresh();
    }

    public static PropCfg cfg(String pathStartWithSlash) {
        return new PropCfg(pathStartWithSlash);
    }

    public String get(String key) {
        try {
            return (String)this.cfgCacheBuilder.get((Object)key);
        }
        catch (Exception e) {
            Log0.error(this.getClass(), e.toString(), e);
            throw new RuntimeException("Can't find {" + key + "}.");
        }
    }

    @Override
    public void refresh() {
        this.refresh(this.pathStartWithSlash);
        try {
            InputStream inputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                this.prop = new Properties();
                inputStream = ((URL)cfgFileCacheBuilder.get((Object)this.pathStartWithSlash)).openStream();
                bufferedInputStream = new BufferedInputStream(inputStream);
                this.prop.load(bufferedInputStream);
            }
            catch (Exception e) {
                try {
                    Log0.error(this.getClass(), e.toString(), e);
                    throw new RuntimeException(e.toString());
                }
                catch (Throwable throwable) {
                    Close0.close(bufferedInputStream);
                    Close0.close(inputStream);
                    throw throwable;
                }
            }
            Close0.close(bufferedInputStream);
            Close0.close(inputStream);
        }
        catch (Exception e) {
            Log0.error(PropCfg.class, KV.ins("pathStartWithSlash", this.pathStartWithSlash).toString(), e);
            throw new RuntimeException("Can't find {" + this.pathStartWithSlash + "}.");
        }
        this.cfgCacheBuilder.cleanUp();
    }
}

