/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.l.ling.lang;

import com.google.common.base.Strings;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.azolla.l.ling.lang.Char0;
import org.azolla.l.ling.util.Log0;

public class String0 {
    public static final String SLASH = String.valueOf('/');
    public static final String POINT = String.valueOf('.');
    public static final String UNDERLINE = String.valueOf('_');
    public static final String EQUAL = String.valueOf('=');
    public static final String COMMA = String.valueOf(',');
    public static final String EMPTY = "";
    public static final String SUCCEED = "Succeed";
    public static final String FAILED = "Failed";
    public static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String DIGITAL = "0123456789";
    private static final HanyuPinyinOutputFormat hanyuPinyinOutputFormat = new HanyuPinyinOutputFormat();

    public static String pinyin(String chineseString) {
        StringBuffer rtnStringBuffer = new StringBuffer();
        String[] pinyinStringArray = null;
        char pinyinChar = '-';
        for (int i = 0; i < chineseString.length(); ++i) {
            pinyinChar = chineseString.charAt(i);
            if (' ' == pinyinChar) {
                rtnStringBuffer.append('-');
                continue;
            }
            if (Char0.isAlphabetOrDigital(pinyinChar)) {
                rtnStringBuffer.append(pinyinChar);
                continue;
            }
            try {
                pinyinStringArray = PinyinHelper.toHanyuPinyinStringArray((char)pinyinChar, (HanyuPinyinOutputFormat)hanyuPinyinOutputFormat);
                if (null != pinyinStringArray && pinyinStringArray.length > 0) {
                    rtnStringBuffer.append(pinyinStringArray[0]);
                    continue;
                }
                rtnStringBuffer.append('_');
                continue;
            }
            catch (BadHanyuPinyinOutputFormatCombination e) {
                Log0.warn(String0.class, e.toString(), e);
            }
        }
        return rtnStringBuffer.toString().toLowerCase();
    }

    public static String nullOrEmptyTo(String string, String to) {
        return Strings.isNullOrEmpty((String)string) ? to : string;
    }

    public static String amp(String string) {
        return string.replaceAll("&", "&amp;");
    }

    public static String lt(String string) {
        return string.replaceAll("<", "&lt;");
    }

    public static String gt(String string) {
        return string.replaceAll(">", "&gt;");
    }

    public static String quot(String string) {
        return string.replaceAll("\"", "&quot;");
    }

    public static String html(String string) {
        return String0.quot(String0.gt(String0.lt(String0.amp(string))));
    }

    static {
        hanyuPinyinOutputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        hanyuPinyinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
    }
}

