/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.l.sunny.tree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class Trees {
    public static void reload(JTree tree) {
        TreeModel model = tree.getModel();
        if (model instanceof DefaultTreeModel) {
            ((DefaultTreeModel)model).reload();
        }
    }

    public static void reload(JTree tree, TreeNode treeNode) {
        TreeModel model = tree.getModel();
        if (model instanceof DefaultTreeModel) {
            ((DefaultTreeModel)model).reload(treeNode);
        }
    }

    public static void expandTree(JTree tree) {
        Trees.expandPath(tree, tree.getPathForRow(0));
    }

    public static void expandPath(JTree tree, TreePath path) {
        tree.expandPath(path);
        Object comp = path.getLastPathComponent();
        if (comp instanceof TreeNode) {
            TreeNode node = (TreeNode)comp;
            for (int index = node.getChildCount() - 1; index >= 0; --index) {
                TreePath childPath = path.pathByAddingChild(node.getChildAt(index));
                Trees.expandPath(tree, childPath);
            }
        }
    }

    public static List<TreeNode> getSelectedLeafs(JTree tree) {
        TreePath[] selectedPaths = tree.getSelectionPaths();
        if (null == selectedPaths) {
            return Collections.emptyList();
        }
        ArrayList selectedLeafs = Lists.newArrayList();
        for (TreePath selectedPath : selectedPaths) {
            Object comp = selectedPath.getLastPathComponent();
            if (!(comp instanceof TreeNode)) continue;
            Trees.fillWithLeafsUnder(selectedLeafs, (TreeNode)comp);
        }
        return selectedLeafs;
    }

    public static List<TreeNode> getLeafsUnder(TreeNode root) {
        ArrayList leafs = Lists.newArrayList();
        Trees.fillWithLeafsUnder(leafs, root);
        return leafs;
    }

    public static void fillWithLeafsUnder(List<TreeNode> container, TreeNode root) {
        if (root.isLeaf()) {
            container.add(root);
            return;
        }
        int end = root.getChildCount();
        for (int index = 0; index < end; ++index) {
            Trees.fillWithLeafsUnder(container, root.getChildAt(index));
        }
    }
}

