/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.l.sunny.table;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class Tables {
    public static void hideColumn(JTable table, int column) {
        if (column < 0 || column > table.getColumnCount()) {
            return;
        }
        TableColumn headColumn = table.getTableHeader().getColumnModel().getColumn(column);
        headColumn.setWidth(0);
        headColumn.setPreferredWidth(0);
        headColumn.setMaxWidth(0);
        headColumn.setMinWidth(0);
        TableColumn dataColumn = table.getColumnModel().getColumn(column);
        dataColumn.setWidth(0);
        dataColumn.setPreferredWidth(0);
        dataColumn.setMaxWidth(0);
        dataColumn.setMinWidth(0);
    }

    public static void fitToContent(JTable table) {
        Tables.fitToContentWithMargin(table, 0);
    }

    public static void fitToContentWithMargin(JTable table, int margin) {
        TableColumnModel colModel = table.getColumnModel();
        Enumeration<TableColumn> columns = colModel.getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            Tables.fitToContentWithMargin(table, colModel.getColumnIndex(column.getIdentifier()), margin);
        }
    }

    public static void fitToContent(JTable table, int col) {
        Tables.fitToContentWithMargin(table, col, 0);
    }

    public static void fitToContentWithMargin(JTable table, int col, int margin) {
        int fitWidth = 0;
        JTableHeader header = table.getTableHeader();
        TableColumn column = table.getColumnModel().getColumn(col);
        TableCellRenderer headerRenderer = column.getHeaderRenderer();
        if (null == headerRenderer) {
            headerRenderer = header.getDefaultRenderer();
        }
        Component headerComp = headerRenderer.getTableCellRendererComponent(table, column.getIdentifier(), false, false, -1, col);
        int headerWidth = headerComp.getPreferredSize().width;
        fitWidth = Math.max(fitWidth, headerWidth);
        int end = table.getRowCount();
        for (int row = 0; row < end; ++row) {
            TableCellRenderer cellRenderer = table.getCellRenderer(row, col);
            Component cellComp = cellRenderer.getTableCellRendererComponent(table, table.getValueAt(row, col), false, false, row, col);
            int cellWidth = cellComp.getPreferredSize().width;
            fitWidth = Math.max(fitWidth, cellWidth);
        }
        fitWidth += table.getIntercellSpacing().width;
        column.setPreferredWidth(fitWidth += margin);
    }

    public static void enableTerminateEditOnFocusLost(JTable table) {
        Tables.setTerminateEditOnFocusLost(table, Boolean.TRUE);
    }

    public static void setTerminateEditOnFocusLost(JTable table, boolean yon) {
        table.putClientProperty("terminateEditOnFocusLost", yon ? Boolean.TRUE : Boolean.FALSE);
    }

    public static boolean isTerminateEditOnFocusLost(JTable table) {
        return Boolean.TRUE.equals(table.getClientProperty("terminateEditOnFocusLost"));
    }

    public static void terminateCellEditing(JTable table) {
        int editingCol;
        int editingRow = table.getEditingRow();
        if (!Tables.cellInBound(table, editingRow, editingCol = table.getEditingColumn())) {
            return;
        }
        TableCellEditor cellEditor = table.getCellEditor();
        if (null == cellEditor) {
            return;
        }
        if (cellEditor.stopCellEditing()) {
            return;
        }
        cellEditor.cancelCellEditing();
    }

    public static void cancelCellEditing(JTable table) {
        TableCellEditor cellEditor = table.getCellEditor();
        if (null != cellEditor) {
            cellEditor.cancelCellEditing();
        }
    }

    public static void selectRowAndScrollToVisible(JTable table, int row) {
        Tables.selectRow(table, row);
        if (table.isRowSelected(row)) {
            Tables.scrollRowToVisible(table, row);
        }
    }

    public static void selectRow(JTable table, int row) {
        if (Tables.rowInBound(table, row)) {
            table.setRowSelectionInterval(row, row);
        }
    }

    public static void scrollRowToVisible(JTable table, int row) {
        if (Tables.rowInBound(table, row)) {
            Rectangle rect = table.getCellRect(row, 0, true);
            rect.x = table.getVisibleRect().x;
            table.scrollRectToVisible(rect);
        }
    }

    public static void scrollColumnToVisible(JTable table, int col) {
        if (Tables.columnInBound(table, col)) {
            Rectangle rect = table.getCellRect(0, col, true);
            rect.y = table.getVisibleRect().y;
            table.scrollRectToVisible(rect);
        }
    }

    public static void scrollCellToVisible(JTable table, int row, int col) {
        if (Tables.cellInBound(table, row, col)) {
            table.scrollRectToVisible(table.getCellRect(row, col, true));
        }
    }

    public static Object getValueAt(JTable table, MouseEvent evt) {
        return Tables.getValueAt(table, evt.getPoint());
    }

    public static Object getValueAt(JTable table, Point pos) {
        int col;
        int row = table.rowAtPoint(pos);
        if (Tables.cellInBound(table, row, col = table.columnAtPoint(pos))) {
            return table.getValueAt(row, col);
        }
        return null;
    }

    public static Object getFocusedValue(JTable table) {
        Object cell = null;
        try {
            cell = table.getValueAt(table.getSelectionModel().getLeadSelectionIndex(), table.getColumnModel().getSelectionModel().getLeadSelectionIndex());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cell;
    }

    public static boolean rowInBound(JTable table, int row) {
        return 0 <= row && table.getRowCount() > row;
    }

    public static boolean columnInBound(JTable table, int col) {
        return 0 <= col && table.getColumnCount() > col;
    }

    public static boolean cellInBound(JTable table, int row, int col) {
        return Tables.rowInBound(table, row) && Tables.columnInBound(table, col);
    }

    public static boolean isTableChangedEntirely(JTable table, TableModelEvent evt) {
        return 0 == evt.getType() && -1 == evt.getColumn() && 0 == evt.getFirstRow() && (table.getRowCount() - 1 == evt.getLastRow() || Integer.MAX_VALUE == evt.getLastRow());
    }

    public static List<Object> getAllIdentifiers(JTable table) {
        TableColumnModel model = table.getColumnModel();
        int count = table.getColumnCount();
        ArrayList identifiers = Lists.newArrayListWithCapacity((int)count);
        for (int index = 0; index < count; ++index) {
            TableColumn col = model.getColumn(index);
            identifiers.add(col.getIdentifier());
        }
        return identifiers;
    }

    public static List<Action> defaultCopyToClipboardActions(JTable table) {
        ArrayList actions = Lists.newArrayListWithCapacity((int)5);
        actions.add(new CopyCellAction(table));
        actions.add(new CopyRowAction(table));
        actions.add(new CopyColumnAction(table));
        actions.add(new CopyTableAction(table));
        return actions;
    }

    private static class CopyCellAction
    extends AbstractAction {
        private static final long serialVersionUID = 1221144650126973340L;
        private final JTable table;

        public CopyCellAction(JTable table) {
            this.table = table;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int row = this.table.getSelectionModel().getLeadSelectionIndex();
            int col = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            Object val = MoreObjects.firstNonNull((Object)this.table.getValueAt(row, col), (Object)"");
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(String.valueOf(val)), null);
        }

        @Override
        public boolean isEnabled() {
            return 0 <= this.table.getSelectionModel().getLeadSelectionIndex() && 0 <= this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        }
    }

    private static class CopyRowAction
    extends AbstractAction {
        private static final long serialVersionUID = 6159926541502989555L;
        private final JTable table;

        public CopyRowAction(JTable table) {
            this.table = table;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int[] rows;
            StringBuilder builder = new StringBuilder();
            for (int row : rows = this.table.getSelectedRows()) {
                int end = this.table.getColumnCount();
                for (int col = 0; col < end; ++col) {
                    Object val = MoreObjects.firstNonNull((Object)this.table.getValueAt(row, col), (Object)"");
                    builder.append(String.valueOf(val));
                    builder.append('\t');
                }
                builder.deleteCharAt(builder.length() - 1);
                builder.append('\n');
            }
            builder.deleteCharAt(builder.length() - 1);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(builder.toString()), null);
        }

        @Override
        public boolean isEnabled() {
            return 0 < this.table.getSelectedRowCount();
        }
    }

    private static class CopyColumnAction
    extends AbstractAction {
        private static final long serialVersionUID = 3331577231220953025L;
        private final JTable table;

        public CopyColumnAction(JTable table) {
            this.table = table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringBuilder builder = new StringBuilder();
            int[] cols = this.table.getSelectedColumns();
            int end = this.table.getRowCount();
            for (int row = 0; row < end; ++row) {
                for (int col : cols) {
                    Object val = MoreObjects.firstNonNull((Object)this.table.getValueAt(row, col), (Object)"");
                    builder.append(String.valueOf(val));
                    builder.append('\t');
                }
                builder.deleteCharAt(builder.length() - 1);
                builder.append('\n');
            }
            builder.deleteCharAt(builder.length() - 1);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(builder.toString()), null);
        }

        @Override
        public boolean isEnabled() {
            return 0 < this.table.getSelectedColumnCount();
        }
    }

    private static class CopyTableAction
    extends AbstractAction {
        private static final long serialVersionUID = -587598878625749292L;
        private final JTable table;

        public CopyTableAction(JTable table) {
            this.table = table;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            StringBuilder builder = new StringBuilder();
            for (int row = 0; row < this.table.getRowCount(); ++row) {
                for (int col = 0; col < this.table.getColumnCount(); ++col) {
                    Object val = MoreObjects.firstNonNull((Object)this.table.getValueAt(row, col), (Object)"");
                    builder.append(String.valueOf(val));
                    builder.append('\t');
                }
                builder.deleteCharAt(builder.length() - 1);
                builder.append('\n');
            }
            builder.deleteCharAt(builder.length() - 1);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(builder.toString()), null);
        }

        @Override
        public boolean isEnabled() {
            return 0 < this.table.getRowCount();
        }
    }
}

