/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.open.ling.io;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.azolla.open.ling.io.Close0;
import org.azolla.open.ling.io.Encode0;
import org.azolla.open.ling.util.KV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class File0 {
    private static final Logger LOG = LoggerFactory.getLogger(File0.class);
    public static final String ILLEGAL_FILENAME_REGEX = "[{/\\\\:*?\"<>|}]";
    public static final String POINT = ".";
    public static final String UNDERLINE = "_";
    public static final String MD5 = "MD5";
    public static final String USER_DIR = "user.dir";
    public static final String USER_HOME = "user.home";
    public static final String ZIP_FILETYPE = "zip";
    public static final String ZIP_FILETYPE_WITH_POINT = ".zip";
    public static final String JAR_FILETYPE = "jar";
    public static final String JAR_FILETYPE_WITH_POINT = ".jar";
    public static final String WAR_FILETYPE = "war";
    public static final String WAR_FILETYPE_WITH_POINT = ".war";
    public static final String TXT_FILETYPE = "txt";
    public static final String TXT_FILETYPE_WITH_POINT = ".txt";
    public static final String BAK_FILETYPE = "bak";
    public static final String BAK_FILETYPE_WITH_POINT = ".bak";

    public static File newFile(String ... strings) {
        return new File(Joiner.on((String)File.separator).join((Object[])strings));
    }

    public static File newFile(File parent, String ... strings) {
        return new File(parent, Joiner.on((String)File.separator).join((Object[])strings));
    }

    public static boolean delFile(File file) {
        boolean rtnBoolean = true;
        if (null != file && file.exists()) {
            rtnBoolean = File0.delFile0(file);
        }
        return rtnBoolean;
    }

    private static boolean delFile0(File file) {
        boolean rtnBoolean = true;
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                rtnBoolean = rtnBoolean && File0.delFile0(subFile);
            }
        }
        rtnBoolean = rtnBoolean && file.delete();
        return rtnBoolean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean emptyFile(File file) {
        boolean rtnBoolean = true;
        if (null == file) return rtnBoolean;
        if (!file.exists()) return rtnBoolean;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                rtnBoolean = rtnBoolean && File0.delFile0(subFile);
                ++n2;
            }
            return rtnBoolean;
        }
        File bakFile = File0.bakFileName(file);
        if (!rtnBoolean) return false;
        if (!file.renameTo(bakFile)) return false;
        boolean bl = true;
        rtnBoolean = bl;
        if (!rtnBoolean) return rtnBoolean;
        try {
            if (!rtnBoolean) return false;
            if (!file.createNewFile()) return false;
            boolean bl2 = true;
            rtnBoolean = bl2;
            if (!rtnBoolean) return rtnBoolean;
            bakFile.delete();
            return rtnBoolean;
        }
        catch (Exception e) {
            LOG.error("[{}]", (Object)KV.ins("file", file), (Object)e);
            bakFile.renameTo(file);
            return false;
        }
    }

    public static File bakFileName(File file) {
        File rtnFile = null;
        if (null != file) {
            rtnFile = File0.newFile(file.getParentFile(), file.getName() + BAK_FILETYPE_WITH_POINT);
        }
        return rtnFile;
    }

    public static List<File> allFile(File file) {
        ArrayList rtnList = Lists.newArrayList();
        if (null != file && file.exists()) {
            rtnList.addAll(File0.allFile0(file));
        }
        return rtnList;
    }

    private static List<File> allFile0(File file) {
        ArrayList rtnList = Lists.newArrayList();
        rtnList.add(file);
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                rtnList.addAll(File0.allFile0(subFile));
            }
        }
        return rtnList;
    }

    public static String fileType(File file) {
        if (null == file) {
            return String.valueOf(file);
        }
        return File0.fileType(file.getName());
    }

    public static String fileType(String fileName) {
        int lastPointIndex = (fileName = String.valueOf(fileName)).lastIndexOf(POINT);
        return -1 == lastPointIndex ? fileName : fileName.substring(lastPointIndex + 1);
    }

    public static String toLegalFileName(String fileName) {
        return File0.toLegalFileName(fileName, UNDERLINE);
    }

    public static String toLegalFileName(String fileName, @Nullable String legalString) {
        fileName = String.valueOf(fileName);
        legalString = Strings.isNullOrEmpty((String)legalString) ? UNDERLINE : legalString;
        return fileName.replaceAll(ILLEGAL_FILENAME_REGEX, legalString);
    }

    public static boolean copy(File from, File to) {
        if (from == null || to == null || !from.exists()) {
            return false;
        }
        return File0.copy0(from, to);
    }

    private static boolean copy0(File from, File to) {
        boolean rtnBoolean = true;
        if (from.isDirectory()) {
            to.mkdirs();
            for (File f : from.listFiles()) {
                rtnBoolean = rtnBoolean && File0.copy0(f, File0.newFile(to, f.getName()));
            }
        } else {
            try {
                com.google.common.io.Files.copy((File)from, (File)to);
            }
            catch (Exception e) {
                LOG.error("[{}]", (Object)KV.ins("from", from).put("to", to), (Object)e);
                rtnBoolean = false;
            }
        }
        return rtnBoolean;
    }

    public static String getUserDir() {
        return System.getProperty(USER_DIR);
    }

    public static String getUserHome() {
        return System.getProperty(USER_HOME);
    }

    public static String getEncoding(String filePath) {
        try {
            return Files.probeContentType(Paths.get(filePath, new String[0]));
        }
        catch (IOException e) {
            return Encode0.SINGLETON.getFileEncoding(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(File file) {
        String rtnString;
        block5: {
            rtnString = null;
            if (file == null || !file.isFile()) break block5;
            int bufferSize = 262144;
            MessageDigest digest = null;
            FileInputStream in = null;
            byte[] buffer = new byte[bufferSize];
            try {
                int len;
                digest = MessageDigest.getInstance(MD5);
                in = new FileInputStream(file);
                while ((len = in.read(buffer, 0, bufferSize)) != -1) {
                    digest.update(buffer, 0, len);
                }
                in.close();
            }
            catch (Exception e) {
                try {
                    LOG.error("[{}]", (Object)KV.ins("file", file), (Object)e);
                }
                catch (Throwable throwable) {
                    Close0.close(in);
                    throw throwable;
                }
                Close0.close(in);
            }
            Close0.close(in);
            rtnString = new BigInteger(1, digest.digest()).toString(16);
        }
        return rtnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVer(File file) {
        int subOff;
        int infoOff;
        int infoVirt;
        byte[] buffer;
        RandomAccessFile raf;
        String rtnString;
        block17: {
            block16: {
                String str;
                block15: {
                    block14: {
                        int peOffset;
                        block13: {
                            block12: {
                                rtnString = "";
                                raf = null;
                                raf = new RandomAccessFile(file, "r");
                                buffer = new byte[64];
                                raf.read(buffer);
                                str = "" + (char)buffer[0] + (char)buffer[1];
                                if ("MZ".equals(str)) break block12;
                                String string = rtnString;
                                Close0.close(raf);
                                return string;
                            }
                            peOffset = File0.unpack(new byte[]{buffer[60], buffer[61], buffer[62], buffer[63]});
                            if (peOffset >= 64) break block13;
                            String string = rtnString;
                            Close0.close(raf);
                            return string;
                        }
                        raf.seek(peOffset);
                        buffer = new byte[24];
                        raf.read(buffer);
                        str = "" + (char)buffer[0] + (char)buffer[1];
                        if ("PE".equals(str)) break block14;
                        String string = rtnString;
                        Close0.close(raf);
                        return string;
                    }
                    int machine = File0.unpack(new byte[]{buffer[4], buffer[5]});
                    if (machine == 332) break block15;
                    String string = rtnString;
                    Close0.close(raf);
                    return string;
                }
                int noSections = File0.unpack(new byte[]{buffer[6], buffer[7]});
                int optHdrSize = File0.unpack(new byte[]{buffer[20], buffer[21]});
                raf.seek(raf.getFilePointer() + (long)optHdrSize);
                boolean resFound = false;
                for (int i = 0; i < noSections; ++i) {
                    buffer = new byte[40];
                    raf.read(buffer);
                    str = "" + (char)buffer[0] + (char)buffer[1] + (char)buffer[2] + (char)buffer[3] + (char)buffer[4];
                    if (!".rsrc".equals(str)) continue;
                    resFound = true;
                    break;
                }
                if (resFound) break block16;
                String i = rtnString;
                Close0.close(raf);
                return i;
            }
            infoVirt = File0.unpack(new byte[]{buffer[12], buffer[13], buffer[14], buffer[15]});
            int infoSize = File0.unpack(new byte[]{buffer[16], buffer[17], buffer[18], buffer[19]});
            infoOff = File0.unpack(new byte[]{buffer[20], buffer[21], buffer[22], buffer[23]});
            raf.seek(infoOff);
            buffer = new byte[infoSize];
            raf.read(buffer);
            int nameEntries = File0.unpack(new byte[]{buffer[12], buffer[13]});
            int idEntries = File0.unpack(new byte[]{buffer[14], buffer[15]});
            boolean infoFound = false;
            subOff = 0;
            for (int i = 0; i < nameEntries + idEntries; ++i) {
                int type = File0.unpack(new byte[]{buffer[i * 8 + 16], buffer[i * 8 + 17], buffer[i * 8 + 18], buffer[i * 8 + 19]});
                if (type != 16) continue;
                infoFound = true;
                subOff = File0.unpack(new byte[]{buffer[i * 8 + 20], buffer[i * 8 + 21], buffer[i * 8 + 22], buffer[i * 8 + 23]});
                break;
            }
            if (infoFound) break block17;
            String i = rtnString;
            Close0.close(raf);
            return i;
        }
        try {
            infoOff = File0.unpack(new byte[]{buffer[(subOff &= Integer.MAX_VALUE) + 20], buffer[subOff + 21], buffer[subOff + 22], buffer[subOff + 23]});
            infoOff = File0.unpack(new byte[]{buffer[(infoOff &= Integer.MAX_VALUE) + 20], buffer[infoOff + 21], buffer[infoOff + 22], buffer[infoOff + 23]});
            int dataOff = File0.unpack(new byte[]{buffer[infoOff], buffer[infoOff + 1], buffer[infoOff + 2], buffer[infoOff + 3]});
            int version1 = File0.unpack(new byte[]{buffer[(dataOff -= infoVirt) + 48], buffer[dataOff + 48 + 1]});
            int version2 = File0.unpack(new byte[]{buffer[dataOff + 48 + 2], buffer[dataOff + 48 + 3]});
            int version3 = File0.unpack(new byte[]{buffer[dataOff + 48 + 4], buffer[dataOff + 48 + 5]});
            int version4 = File0.unpack(new byte[]{buffer[dataOff + 48 + 6], buffer[dataOff + 48 + 7]});
            rtnString = version2 + POINT + version1 + POINT + version4 + POINT + version3;
        }
        catch (Exception e) {
            try {
                LOG.error("[{}]", (Object)KV.ins("file", file), (Object)e);
            }
            catch (Throwable throwable) {
                Close0.close(raf);
                throw throwable;
            }
            Close0.close(raf);
        }
        Close0.close(raf);
        return rtnString;
    }

    private static int unpack(byte[] b) {
        int num = 0;
        for (int i = 0; i < b.length; ++i) {
            num = 256 * num + (b[b.length - 1 - i] & 0xFF);
        }
        return num;
    }

    public static void main(String[] args) {
        String s1 = "";
        System.out.println(new File(s1).getAbsolutePath());
        List stringList = null;
        for (String s : stringList) {
            System.out.println(s);
        }
    }
}

