/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.open.ling.lang;

import com.google.common.base.Strings;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.azolla.open.ling.exception.code.AzollaCode;
import org.azolla.open.ling.io.Close0;
import org.azolla.open.ling.util.KV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Command0 {
    private static final Logger LOG = LoggerFactory.getLogger(Command0.class);
    private static final String INPUT = "INPUT";
    private static final String ERROR = "ERROR";
    public static final String CMD_PAUSE_FLAG = ">pause";
    public static final String SH_PAUSE_FLAG = ">read -n 1 -p";
    public static final long DEFAULT_TIMEOUT_MINUTES = 33L;

    public static boolean exec(String command) {
        return Command0.exec(command, 33L);
    }

    public static boolean exec(String command, long timeout) {
        return Command0.exec(command, timeout, false, null);
    }

    public static boolean exec(String command, boolean value4pause, String pauseFlag) {
        return Command0.exec(command, 33L, value4pause, pauseFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exec(String command, long timeout, boolean value4pause, String pauseFlag) {
        LOG.info(command);
        boolean rtnBoolean = true;
        if (!Strings.isNullOrEmpty((String)command)) {
            Process process = null;
            Future<Boolean> iFuture = null;
            Future<Boolean> eFuture = null;
            try {
                process = Runtime.getRuntime().exec(command);
                ExecutorService es = Executors.newFixedThreadPool(2);
                iFuture = es.submit(new CommandTask(process.getInputStream(), INPUT, value4pause, pauseFlag));
                eFuture = es.submit(new CommandTask(process.getErrorStream(), ERROR, value4pause, pauseFlag));
                rtnBoolean = iFuture.get(timeout, TimeUnit.MINUTES) != false && eFuture.get(timeout, TimeUnit.MINUTES) != false && process.waitFor() == 0;
            }
            catch (Exception e) {
                LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.COMMAND_ERROR, KV.ins("command", command).put("timeout", timeout).put("value4pause", value4pause).put("pauseFlag", pauseFlag), e});
                rtnBoolean = false;
            }
            finally {
                if (null != iFuture) {
                    iFuture.cancel(true);
                }
                if (null != eFuture) {
                    eFuture.cancel(true);
                }
                if (null != process) {
                    process.destroy();
                }
            }
        }
        return rtnBoolean;
    }

    private static class CommandTask
    implements Callable<Boolean> {
        private static final Logger LOG = LoggerFactory.getLogger(CommandTask.class);
        private InputStream inputStream;
        private String type;
        private boolean value4pause;
        private String pauseFlag;

        public CommandTask(InputStream inputStream, String type, boolean value4pause, String pauseFlag) {
            this.inputStream = inputStream;
            this.type = type;
            this.value4pause = value4pause;
            this.pauseFlag = pauseFlag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            InputStreamReader inputStreamReader;
            LineNumberReader lineNumberReader;
            boolean rtnBoolean;
            block7: {
                rtnBoolean = true;
                lineNumberReader = null;
                inputStreamReader = null;
                String line = null;
                try {
                    inputStreamReader = new InputStreamReader(this.inputStream);
                    lineNumberReader = new LineNumberReader(inputStreamReader);
                    if (Strings.isNullOrEmpty((String)this.pauseFlag)) {
                        while ((line = lineNumberReader.readLine()) != null) {
                            LOG.info(this.type + "=" + line);
                        }
                        break block7;
                    }
                    while ((line = lineNumberReader.readLine()) != null) {
                        LOG.info(this.type + "=" + line);
                        if (line.toLowerCase(Locale.ENGLISH).indexOf(this.pauseFlag) <= -1) continue;
                        rtnBoolean = this.value4pause;
                        break;
                    }
                }
                catch (Exception e) {
                    try {
                        LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.COMMAND_ERROR, KV.ins("type", this.type).put("value4pause", this.value4pause).put("pauseFlag", this.pauseFlag), e});
                        rtnBoolean = false;
                    }
                    catch (Throwable throwable) {
                        Close0.close(lineNumberReader);
                        Close0.close(inputStreamReader);
                        throw throwable;
                    }
                    Close0.close(lineNumberReader);
                    Close0.close(inputStreamReader);
                }
            }
            Close0.close(lineNumberReader);
            Close0.close(inputStreamReader);
            return rtnBoolean;
        }
    }
}

