/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.open.ling.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import org.azolla.open.ling.exception.code.AzollaCode;
import org.azolla.open.ling.util.KV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Date0 {
    private static final Logger LOG = LoggerFactory.getLogger(Date0.class);
    public static final String Y = "yyyy";
    public static final String M = "MM";
    public static final String D = "dd";
    public static final String YM = "yyyyMM";
    public static final String YMD = "yyyyMMdd";
    public static final String Y_M = "yyyy-MM";
    public static final String Y_M_D = "yyyy-MM-dd";
    public static final String H = "HH";
    public static final String MI = "mm";
    public static final String S = "ss";
    public static final String Y_M_D_H_MI_S = "yyyy_MM_dd_HH_mm_ss";
    public static final String DATE = "yyyy-MM-dd";
    public static final String TIME = "HH:mm:ss";
    public static final String DATA_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String DATATIME = "yyyyMMddHHmmss";

    public static final String DATATIME() {
        return Date0.toString(Date0.now(), DATATIME);
    }

    public static final String YM() {
        return Date0.toString(Date0.now(), YM);
    }

    public static Date now() {
        return new Date();
    }

    public static String toString(Date date) {
        return Date0.toString(date, DATA_TIME);
    }

    public static String toString(String pattern) {
        return Date0.toString(Date0.now(), pattern);
    }

    public static String toString(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public static long toUnixTimestamp() {
        return Date0.toUnixTimestamp(Date0.now());
    }

    public static long toUnixTimestamp(Date date) {
        return date.getTime();
    }

    public static Date valueOf(long timestamp) {
        return new Date(timestamp);
    }

    public static Date valueOf(String date) {
        return Date0.valueOf(date, DATA_TIME);
    }

    public static Date valueOf(String date, String pattern) {
        Date rtnDate = null;
        try {
            rtnDate = new SimpleDateFormat(pattern).parse(date);
        }
        catch (ParseException e) {
            LOG.error("[ErrorCode={}][{}]\n{}", new Object[]{AzollaCode.PARSEEXCEPTION, KV.ins("date", date).put("pattern", pattern), e});
            rtnDate = null;
        }
        return rtnDate;
    }

    public static int compareWithNow(@Nonnull Date date) {
        return date.compareTo(Date0.now());
    }
}

