/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.tzfe.panel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.azolla.l.ling.util.Random0;
import org.azolla.p.tzfe.cons.NumCons;
import org.azolla.p.tzfe.model.GridButton;

public class TzfePanel
extends JPanel {
    private static final long serialVersionUID = 7581667051127144281L;
    public static final int W = 400;
    public static final int H = 400;
    public static Map<Integer, GridButton> gridButtonMap = Maps.newHashMap();
    private static TzfePanel instance;

    public static TzfePanel single() {
        instance = null == instance ? new TzfePanel() : instance;
        return instance;
    }

    private TzfePanel() {
        this.initUI();
        this.initListener();
    }

    private void initListener() {
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "VK_UP");
        this.getActionMap().put("VK_UP", new AbstractAction(){
            private static final long serialVersionUID = 4819502628024769956L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TzfePanel.this.doAction(38);
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "VK_DOWN");
        this.getActionMap().put("VK_DOWN", new AbstractAction(){
            private static final long serialVersionUID = -6424658478553779272L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TzfePanel.this.doAction(40);
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0), "VK_LEFT");
        this.getActionMap().put("VK_LEFT", new AbstractAction(){
            private static final long serialVersionUID = -27041905896290458L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TzfePanel.this.doAction(37);
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0), "VK_RIGHT");
        this.getActionMap().put("VK_RIGHT", new AbstractAction(){
            private static final long serialVersionUID = -1474793824803787971L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TzfePanel.this.doAction(39);
            }
        });
    }

    private void doAction(int key) {
        boolean goodjob = false;
        if (key == 38) {
            goodjob = this.up();
        } else if (key == 40) {
            goodjob = this.down();
        } else if (key == 37) {
            goodjob = this.left();
        } else if (key == 39) {
            goodjob = this.right();
        }
        if (!goodjob) {
            return;
        }
        this.next();
    }

    private boolean right() {
        boolean movinged = false;
        boolean[] computinged = new boolean[]{false, false, false, false};
        GridButton prev = null;
        GridButton next = null;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                int unreachable = y * 4;
                for (int z = y * 4 + 3; z > unreachable; --z) {
                    prev = gridButtonMap.get(z);
                    next = gridButtonMap.get(z - 1);
                    if (!computinged[y] && prev.getNumber() != 0 && prev.getNumber() == next.getNumber()) {
                        prev.setNumber(prev.getNumber() * 2);
                        next.setNumber(0);
                        computinged[y] = true;
                        if (z - 1 - 1 - 1 < unreachable) continue;
                        prev = gridButtonMap.get(z - 1 - 1);
                        next = gridButtonMap.get(z - 1 - 1 - 1);
                        if (prev.getNumber() == 0 || prev.getNumber() != next.getNumber()) continue;
                        prev.setNumber(prev.getNumber() * 2);
                        next.setNumber(0);
                        continue;
                    }
                    if (prev.getNumber() != 0 || next.getNumber() == 0) continue;
                    prev.setNumber(next.getNumber());
                    next.setNumber(0);
                    movinged = true;
                }
            }
        }
        return movinged || computinged[0] || computinged[1] || computinged[2] || computinged[3];
    }

    private boolean left() {
        boolean movinged = false;
        boolean[] computinged = new boolean[]{false, false, false, false};
        GridButton prev = null;
        GridButton next = null;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                int unreachable = y * 4 + 3;
                for (int z = y * 4; z < unreachable; ++z) {
                    prev = gridButtonMap.get(z);
                    next = gridButtonMap.get(z + 1);
                    if (!computinged[y] && prev.getNumber() != 0 && prev.getNumber() == next.getNumber()) {
                        prev.setNumber(prev.getNumber() * 2);
                        next.setNumber(0);
                        computinged[y] = true;
                        if (z + 1 + 1 + 1 > unreachable) continue;
                        prev = gridButtonMap.get(z + 1 + 1);
                        next = gridButtonMap.get(z + 1 + 1 + 1);
                        if (prev.getNumber() == 0 || prev.getNumber() != next.getNumber()) continue;
                        prev.setNumber(prev.getNumber() * 2);
                        next.setNumber(0);
                        continue;
                    }
                    if (prev.getNumber() != 0 || next.getNumber() == 0) continue;
                    prev.setNumber(next.getNumber());
                    next.setNumber(0);
                    movinged = true;
                }
            }
        }
        return movinged || computinged[0] || computinged[1] || computinged[2] || computinged[3];
    }

    private boolean down() {
        boolean movinged = false;
        boolean[] computinged = new boolean[]{false, false, false, false};
        GridButton prev = null;
        GridButton next = null;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                int unreachable = x;
                for (int z = 12 + x; z > unreachable; z -= 4) {
                    prev = gridButtonMap.get(z);
                    next = gridButtonMap.get(z - 4);
                    if (!computinged[x] && prev.getNumber() != 0 && prev.getNumber() == next.getNumber()) {
                        prev.setNumber(prev.getNumber() * 2);
                        next.setNumber(0);
                        computinged[x] = true;
                        if (z - 4 - 4 - 4 < unreachable) continue;
                        prev = gridButtonMap.get(z - 4 - 4);
                        next = gridButtonMap.get(z - 4 - 4 - 4);
                        if (prev.getNumber() == 0 || prev.getNumber() != next.getNumber()) continue;
                        prev.setNumber(prev.getNumber() * 2);
                        next.setNumber(0);
                        continue;
                    }
                    if (prev.getNumber() != 0 || next.getNumber() == 0) continue;
                    prev.setNumber(next.getNumber());
                    next.setNumber(0);
                    movinged = true;
                }
            }
        }
        return movinged || computinged[0] || computinged[1] || computinged[2] || computinged[3];
    }

    private boolean up() {
        boolean movinged = false;
        boolean[] computinged = new boolean[]{false, false, false, false};
        GridButton prev = null;
        GridButton next = null;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                int unreachable = 12 + x;
                for (int z = x; z < unreachable; z += 4) {
                    prev = gridButtonMap.get(z);
                    next = gridButtonMap.get(z + 4);
                    if (!computinged[x] && prev.getNumber() != 0 && prev.getNumber() == next.getNumber()) {
                        prev.setNumber(prev.getNumber() * 2);
                        next.setNumber(0);
                        computinged[x] = true;
                        if (z + 4 + 4 + 4 > unreachable) continue;
                        prev = gridButtonMap.get(z + 4 + 4);
                        next = gridButtonMap.get(z + 4 + 4 + 4);
                        if (prev.getNumber() == 0 || prev.getNumber() != next.getNumber()) continue;
                        prev.setNumber(prev.getNumber() * 2);
                        next.setNumber(0);
                        continue;
                    }
                    if (prev.getNumber() != 0 || next.getNumber() == 0) continue;
                    prev.setNumber(next.getNumber());
                    next.setNumber(0);
                    movinged = true;
                }
            }
        }
        return movinged || computinged[0] || computinged[1] || computinged[2] || computinged[3];
    }

    private void next() {
        this.roundGridButton().setNumber(NumCons.roundNum());
        SwingUtilities.updateComponentTreeUI(this);
        if (this.isGameover()) {
            JOptionPane.showMessageDialog(TzfePanel.single(), "Gameover!");
            this.reset();
        }
    }

    private void reset() {
        for (int i = 0; i < 16; ++i) {
            gridButtonMap.get(i).setNumber(0);
        }
        this.next();
    }

    private boolean isGameover() {
        boolean hasFreeGrid = this.roundGridButton() != null;
        int currentLocation = 0;
        int currentDown = 0;
        int currentRight = 0;
        int unreachableDown = 0;
        int unreachableRight = 0;
        GridButton prev = null;
        GridButton next = null;
        boolean hasSameGrid = false;
        block0: for (int x = 0; x < 4 && !hasSameGrid && !hasFreeGrid; ++x) {
            unreachableDown = 12 + x;
            for (int y = 0; y < 4; ++y) {
                unreachableRight = y * 4 + 3;
                currentLocation = x + y * 4;
                currentDown = currentLocation + 4;
                currentRight = currentLocation + 1;
                prev = gridButtonMap.get(currentLocation);
                if (currentDown <= unreachableDown) {
                    next = gridButtonMap.get(currentDown);
                    if (prev.getNumber() != 0 && prev.getNumber() == next.getNumber()) {
                        hasSameGrid = true;
                        continue block0;
                    }
                }
                if (currentRight > unreachableRight) continue;
                next = gridButtonMap.get(currentRight);
                if (prev.getNumber() == 0 || prev.getNumber() != next.getNumber()) continue;
                hasSameGrid = true;
                continue block0;
            }
        }
        return !hasFreeGrid && !hasSameGrid;
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
    }

    @Override
    public synchronized void addMouseWheelListener(MouseWheelListener l) {
    }

    private void initUI() {
        this.setLayout(new GridLayout(4, 4, 3, 3));
        this.setBackground(new Color(192, 192, 192, 192));
        for (int i = 0; i < 16; ++i) {
            GridButton gridButton = new GridButton(i % 4, i / 4);
            this.add(gridButton);
            gridButtonMap.put(i, gridButton);
        }
        this.next();
    }

    private GridButton roundGridButton() {
        GridButton gridButton = null;
        ArrayList freeGridButtonList = Lists.newArrayList();
        for (int i = 0; i < 16; ++i) {
            gridButton = gridButtonMap.get(i);
            if (gridButton.getNumber() != 0) continue;
            freeGridButtonList.add(gridButton);
        }
        gridButton = null;
        if (freeGridButtonList.size() > 0) {
            gridButton = (GridButton)freeGridButtonList.get(Random0.nextRangeInt((int)freeGridButtonList.size()));
        }
        return gridButton;
    }
}

