/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.james.bo;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.azolla.l.ling.lang.String0;
import org.azolla.p.james.bo.DBColumnBo;
import org.azolla.p.james.bo.ExcelSheetBo;
import org.azolla.p.james.bo.JamesBo;

public class DBTableBo {
    private String dbTable;
    private String eSheet;
    private List<DBColumnBo> dbColumnBoList = Lists.newArrayList();
    private String sqlTemplate = "insert into {0}({1}) select {2};";

    public List<String> getSqlList() {
        ArrayList rtnList = Lists.newArrayList();
        ExcelSheetBo excelSheetBo = JamesBo.single().getStringExcelSheetBoMap().get(this.eSheet);
        List<String[]> rowList = excelSheetBo.getNoErrorRowList();
        rowList = this.separator(rowList, excelSheetBo);
        rtnList.addAll(this.generateSqlList(rowList, excelSheetBo));
        return rtnList;
    }

    public List<String> generateSqlList(List<String[]> rowList, ExcelSheetBo excelSheetBo) {
        ArrayList sqlList = Lists.newArrayList();
        for (String[] colArray : rowList) {
            sqlList.add(this.generateSql(colArray, excelSheetBo));
        }
        return sqlList;
    }

    public String generateSql(String[] colArray, ExcelSheetBo excelSheetBo) {
        StringBuffer colStringBuffer = new StringBuffer();
        StringBuffer valStringBuffer = new StringBuffer();
        for (DBColumnBo dbColumnBo : this.dbColumnBoList) {
            if ("Y".equalsIgnoreCase(dbColumnBo.getDbSeq())) continue;
            colStringBuffer.append(String0.COMMA).append(dbColumnBo.getDbColumn());
            if (Strings.isNullOrEmpty((String)dbColumnBo.geteColumn())) {
                valStringBuffer.append(String0.COMMA).append('\'').append(dbColumnBo.getDefaultValue()).append('\'');
                continue;
            }
            if (Strings.isNullOrEmpty((String)dbColumnBo.getDbColumnSql())) {
                valStringBuffer.append(String0.COMMA).append('\'').append(colArray[excelSheetBo.getStringIntegerMap().get(dbColumnBo.geteColumn())]).append('\'');
                continue;
            }
            if (dbColumnBo.geteColumn().contains(String0.COMMA)) {
                String[] eColArray = dbColumnBo.geteColumn().split(String0.COMMA);
                String[] vColArray = new String[eColArray.length];
                for (int i = 0; i < eColArray.length; ++i) {
                    vColArray[i] = colArray[excelSheetBo.getStringIntegerMap().get(eColArray[i])];
                }
                valStringBuffer.append(String0.COMMA).append(new MessageFormat(dbColumnBo.getDbColumnSql()).format(vColArray));
                continue;
            }
            valStringBuffer.append(String0.COMMA).append(MessageFormat.format(dbColumnBo.getDbColumnSql(), colArray[excelSheetBo.getStringIntegerMap().get(dbColumnBo.geteColumn())]));
        }
        return MessageFormat.format(this.sqlTemplate, this.dbTable, colStringBuffer.toString().substring(1), valStringBuffer.toString().substring(1));
    }

    public List<String[]> separator(List<String[]> rowList, ExcelSheetBo excelSheetBo) {
        List<String[]> rtnList = rowList;
        String separator = null;
        Integer colIndex = null;
        for (DBColumnBo dbColumnBo : this.dbColumnBoList) {
            separator = dbColumnBo.getSeparator();
            colIndex = excelSheetBo.getStringIntegerMap().get(dbColumnBo.geteColumn());
            if (Strings.isNullOrEmpty((String)separator) || colIndex == null) continue;
            rtnList = this.separator(rtnList, separator, colIndex);
        }
        return rtnList;
    }

    public List<String[]> separator(@Nonnull List<String[]> rowList, @Nonnull String separator, @Nonnull Integer colIndex) {
        ArrayList newRowList = Lists.newArrayList();
        String cell = null;
        for (String[] rowArray : rowList) {
            cell = rowArray[colIndex];
            if (cell != null && cell.contains(separator)) {
                for (String s : cell.split(separator)) {
                    String[] newRowArray = Arrays.copyOf(rowArray, rowArray.length);
                    newRowArray[colIndex.intValue()] = s;
                    newRowList.add(newRowArray);
                }
                continue;
            }
            newRowList.add(rowArray);
        }
        return newRowList;
    }

    public String getDbTable() {
        return this.dbTable;
    }

    public DBTableBo setDbTable(String dbTable) {
        this.dbTable = dbTable;
        return this;
    }

    public String geteSheet() {
        return this.eSheet;
    }

    public DBTableBo seteSheet(String eSheet) {
        this.eSheet = eSheet;
        return this;
    }

    public List<DBColumnBo> getDbColumnBoList() {
        return this.dbColumnBoList;
    }

    public DBTableBo setDbColumnBoList(List<DBColumnBo> dbColumnBoList) {
        this.dbColumnBoList = dbColumnBoList;
        return this;
    }

    public DBTableBo addDbColumnBo(DBColumnBo dbColumnBo) {
        if (dbColumnBo != null) {
            return this.addDbColumnBoList(Lists.newArrayList((Object[])new DBColumnBo[]{dbColumnBo}));
        }
        return this;
    }

    public DBTableBo addDbColumnBoList(List<DBColumnBo> dbColumnBoList) {
        if (dbColumnBoList != null) {
            this.dbColumnBoList.addAll(dbColumnBoList);
        }
        return this;
    }
}

