/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.james.bo;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.azolla.l.ling.util.Log0;
import org.azolla.p.james.bo.ExcelColumnBo;

public class ExcelSheetBo {
    private String sheet;
    private Map<String, ExcelColumnBo> stringExcelColumnBoMap = Maps.newHashMap();
    private Map<String, Integer> stringIntegerMap = Maps.newHashMap();
    private String[][] dataArray = new String[0][];
    private Map<Integer, Integer> errorRowIndexMap = Maps.newHashMap();

    public List<String[]> getNoErrorRowList() {
        ArrayList noErrorRowList = Lists.newArrayList();
        Set<Integer> errorRowSet = this.errorRowIndexMap.keySet();
        int colLength = this.dataArray[0].length;
        for (int rowIndex = 0; rowIndex < this.dataArray.length && !errorRowSet.contains(rowIndex); ++rowIndex) {
            noErrorRowList.add(Arrays.copyOf(this.dataArray[rowIndex], colLength));
        }
        return noErrorRowList;
    }

    public void validate() {
        this.stringExcelColumnBoMap.values().forEach(excelColumnBo -> {
            Integer colIndex = this.stringIntegerMap.get(excelColumnBo.getColumn());
            if (colIndex >= this.dataArray[0].length) {
                Log0.error(this.getClass(), (String)("Can't find " + this.sheet + "." + excelColumnBo.getColumn() + "!"));
            } else {
                excelColumnBo.getValidaterList().forEach(validater -> {
                    for (int rowIndex = 0; rowIndex < this.dataArray.length && !this.errorRowIndexMap.keySet().contains(rowIndex); ++rowIndex) {
                        if (validater.validate(this.dataArray[rowIndex][colIndex]).booleanValue()) continue;
                        this.errorRowIndexMap.put(rowIndex, colIndex);
                    }
                });
            }
        });
    }

    public void convert() {
        this.stringExcelColumnBoMap.values().forEach(excelColumnBo -> {
            Integer colIndex = this.stringIntegerMap.get(excelColumnBo.getColumn());
            if (colIndex >= this.dataArray[0].length) {
                Log0.error(this.getClass(), (String)("Can't find " + this.sheet + "." + excelColumnBo.getColumn() + "!"));
            } else {
                excelColumnBo.getConverterList().forEach(converter -> {
                    for (int rowIndex = 0; rowIndex < this.dataArray.length && !this.errorRowIndexMap.keySet().contains(rowIndex); ++rowIndex) {
                        if (converter.convert(this.dataArray, rowIndex, colIndex).booleanValue()) continue;
                        this.errorRowIndexMap.put(rowIndex, colIndex);
                    }
                });
            }
        });
    }

    public String getSheet() {
        return this.sheet;
    }

    public ExcelSheetBo setSheet(String sheet) {
        this.sheet = sheet;
        return this;
    }

    public Map<String, ExcelColumnBo> getStringExcelColumnBoMap() {
        return this.stringExcelColumnBoMap;
    }

    public ExcelSheetBo setStringExcelColumnBoMap(Map<String, ExcelColumnBo> stringExcelColumnBoMap) {
        this.stringExcelColumnBoMap = stringExcelColumnBoMap;
        return this;
    }

    public ExcelSheetBo addExcelColumnBo(ExcelColumnBo excelColumnBo) {
        if (excelColumnBo == null) {
            return this;
        }
        HashMap newStringExcelColumnBoMap = Maps.newHashMap();
        newStringExcelColumnBoMap.put(excelColumnBo.getColumn(), excelColumnBo);
        return this.addStringExcelColumnBoMap(newStringExcelColumnBoMap);
    }

    public ExcelSheetBo addStringExcelColumnBoMap(Map<String, ExcelColumnBo> stringExcelColumnBoMap) {
        this.stringExcelColumnBoMap.putAll(stringExcelColumnBoMap);
        return this;
    }

    public Map<String, Integer> getStringIntegerMap() {
        return this.stringIntegerMap;
    }

    public ExcelSheetBo setStringIntegerMap(Map<String, Integer> stringIntegerMap) {
        this.stringIntegerMap = stringIntegerMap;
        return this;
    }

    public ExcelSheetBo addStringInteger(String columnName, Integer columnIndex) {
        if (!Strings.isNullOrEmpty((String)columnName) && columnIndex != null) {
            this.stringIntegerMap.put(columnName, columnIndex);
        }
        return this;
    }

    public ExcelSheetBo addStringIntegerMap(Map<String, Integer> stringIntegerMap) {
        this.stringIntegerMap.putAll(stringIntegerMap);
        return this;
    }

    public String[][] getDataArray() {
        return this.dataArray;
    }

    public void setDataArray(String[][] dataArray) {
        this.dataArray = dataArray;
    }

    public Map<Integer, Integer> getErrorRowIndexMap() {
        return this.errorRowIndexMap;
    }

    public void setErrorRowIndexMap(Map<Integer, Integer> errorRowIndexMap) {
        this.errorRowIndexMap = errorRowIndexMap;
    }
}

