/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.james.bo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.azolla.l.ling.io.Close0;
import org.azolla.l.ling.io.File0;
import org.azolla.l.ling.util.Log0;
import org.azolla.p.james.bo.DBTableBo;
import org.azolla.p.james.bo.ExcelSheetBo;
import org.azolla.p.james.util.Cons;

public class JamesBo {
    private Map<String, ExcelSheetBo> stringExcelSheetBoMap = Maps.newHashMap();
    private List<DBTableBo> dbTableBoList = Lists.newArrayList();

    public static final JamesBo single() {
        return SigletonHolder.instance;
    }

    public void clear() {
        this.stringExcelSheetBoMap.clear();
        this.dbTableBoList.clear();
    }

    public void validate() {
        this.stringExcelSheetBoMap.values().forEach(excelSheetBo -> excelSheetBo.validate());
    }

    public void convert() {
        this.stringExcelSheetBoMap.values().forEach(excelSheetBo -> excelSheetBo.convert());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSql(File folder) {
        File sqlFile = null;
        FileWriter fw = null;
        BufferedWriter bw = null;
        for (DBTableBo dbTableBo : this.dbTableBoList) {
            sqlFile = File0.newFile((File)folder, (String[])new String[]{"" + System.currentTimeMillis() + dbTableBo.getDbTable() + ".sql"});
            try {
                fw = new FileWriter(sqlFile, false);
                bw = new BufferedWriter(fw);
                for (String sql : dbTableBo.getSqlList()) {
                    bw.write(sql);
                    bw.newLine();
                }
                bw.flush();
            }
            catch (Exception e) {
                try {
                    Log0.error(this.getClass(), (String)e.toString(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    Close0.close(bw);
                    Close0.close((Closeable)fw);
                    throw throwable;
                }
                Close0.close((Closeable)bw);
                Close0.close((Closeable)fw);
                continue;
            }
            Close0.close((Closeable)bw);
            Close0.close((Closeable)fw);
        }
    }

    public Map<String, ExcelSheetBo> getStringExcelSheetBoMap() {
        return this.stringExcelSheetBoMap;
    }

    public JamesBo setStringExcelSheetBoMap(Map<String, ExcelSheetBo> stringExcelSheetBoMap) {
        this.stringExcelSheetBoMap = stringExcelSheetBoMap;
        return this;
    }

    public JamesBo addExcelSheetBo(ExcelSheetBo excelSheetBo) {
        if (excelSheetBo == null) {
            return this;
        }
        HashMap newStringExcelSheetBoMap = Maps.newHashMap();
        newStringExcelSheetBoMap.put(excelSheetBo.getSheet(), excelSheetBo);
        return this.addStringExcelSheetBoMap(newStringExcelSheetBoMap);
    }

    public JamesBo addStringExcelSheetBoMap(Map<String, ExcelSheetBo> stringExcelSheetBoMap) {
        this.stringExcelSheetBoMap.putAll(stringExcelSheetBoMap);
        return this;
    }

    public List<DBTableBo> getDbTableBoList() {
        return this.dbTableBoList;
    }

    public JamesBo setDbTableBoList(List<DBTableBo> dbTableBoList) {
        this.dbTableBoList = dbTableBoList;
        return this;
    }

    public JamesBo addDbTableBo(DBTableBo dbTableBo) {
        return dbTableBo == null ? this : this.addDbTableBoList(Lists.newArrayList((Object[])new DBTableBo[]{dbTableBo}));
    }

    public JamesBo addDbTableBoList(List<DBTableBo> dbTableBoList) {
        if (dbTableBoList != null) {
            this.dbTableBoList.addAll(dbTableBoList);
        }
        return this;
    }

    public Boolean hasError() {
        Boolean rtnBoolean = false;
        for (ExcelSheetBo excelSheetBo : this.stringExcelSheetBoMap.values()) {
            if (excelSheetBo.getErrorRowIndexMap().size() <= 0) continue;
            rtnBoolean = true;
        }
        return rtnBoolean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordError(File folder) {
        File errorLogFile = File0.newFile((File)folder, (String[])new String[]{"error.log"});
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(errorLogFile, false);
            bw = new BufferedWriter(fw);
            for (ExcelSheetBo excelSheetBo : this.stringExcelSheetBoMap.values()) {
                for (Map.Entry<Integer, Integer> entry : excelSheetBo.getErrorRowIndexMap().entrySet()) {
                    bw.write(excelSheetBo.getSheet() + ":" + (entry.getKey() + Cons.JAMES_DATA_TITLE_ROW_INDEX + 2) + "," + (entry.getValue() + 1));
                    bw.newLine();
                }
                bw.flush();
            }
        }
        catch (Exception e) {
            try {
                Log0.error(this.getClass(), (String)e.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                Close0.close(bw);
                Close0.close((Closeable)fw);
                throw throwable;
            }
            Close0.close((Closeable)bw);
            Close0.close((Closeable)fw);
        }
        Close0.close((Closeable)bw);
        Close0.close((Closeable)fw);
    }

    private static class SigletonHolder {
        private static final JamesBo instance = new JamesBo();

        private SigletonHolder() {
        }
    }
}

