/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.james.panel;

import com.google.common.base.Strings;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.azolla.l.ling.io.File0;
import org.azolla.l.ling.lang.String0;
import org.azolla.l.ling.net.Url0;
import org.azolla.l.ling.util.Date0;
import org.azolla.l.ling.util.Log0;
import org.azolla.l.sunny.dlg.Msg;
import org.azolla.l.sunny.layout.GBC;
import org.azolla.l.sunny.task.UITasks;
import org.azolla.p.james.bo.ExcelSheetBo;
import org.azolla.p.james.bo.JamesBo;
import org.azolla.p.james.i18n.I18N;
import org.azolla.p.james.startup.Startup;
import org.azolla.p.james.util.ExcelParser;

public class JamesPanel
extends JPanel {
    public static final int W = 600;
    public static final int H = 100;
    JTextField pathTextField = new JTextField();
    JButton selectButton = new JButton(I18N.get("Select"));
    JButton downloadTemplateButton = new JButton(I18N.get("DownloadTemplate"));
    JButton generateSqlButton = new JButton(I18N.get("GenerateSql"));

    private JamesPanel() {
        this.initUI();
        this.initListener();
    }

    public static final JamesPanel single() {
        return SigletonHolder.instance;
    }

    private void initListener() {
        this.selectButton.addActionListener(e -> {
            JFileChooser jFileChooser = this.createJFileChooser();
            int result = jFileChooser.showOpenDialog(JamesPanel.single());
            if (result == 0) {
                this.pathTextField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        });
        this.downloadTemplateButton.addActionListener(e -> {
            JFileChooser jFileChooser = this.createJFileChooser();
            int result = jFileChooser.showSaveDialog(JamesPanel.single());
            if (result == 0) {
                if (File0.copy((File)File0.newFile((String[])new String[]{Url0.getURL((String)I18N.get("TEMPLATE_NAME")).getPath()}), (File)jFileChooser.getSelectedFile())) {
                    Msg.info((Component)JamesPanel.single(), (Object)I18N.get("MSG_OPERATION_SUCCESSFULLY"));
                } else {
                    Msg.error((Component)JamesPanel.single(), (Object)I18N.get("MSG_OPERATION_FAILED"));
                }
            }
        });
        this.generateSqlButton.addActionListener(e -> {
            File currentFile = null;
            if (!Strings.isNullOrEmpty((String)this.pathTextField.getText())) {
                currentFile = File0.newFile((String[])new String[]{this.pathTextField.getText()});
            }
            if (currentFile != null && currentFile.exists()) {
                final File finalCurrentFile = currentFile;
                try {
                    UITasks.createUITask(null, (Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            Startup.refreshTitle(I18N.get("ING_PROCESS"));
                            JamesBo.single().clear();
                            ExcelParser.SIGLETON.parseJamesExcel(finalCurrentFile);
                            ExcelParser.SIGLETON.parseJamesDB(finalCurrentFile);
                            for (ExcelSheetBo excelSheetBo : JamesBo.single().getStringExcelSheetBoMap().values()) {
                                ExcelParser.SIGLETON.parseJamesData(finalCurrentFile, excelSheetBo);
                            }
                            JamesBo.single().validate();
                            JamesBo.single().convert();
                            File folder = File0.newFile((File)finalCurrentFile.getParentFile(), (String[])new String[]{Date0.DATATIME()});
                            folder.mkdirs();
                            JamesBo.single().generateSql(folder);
                            if (JamesBo.single().hasError().booleanValue()) {
                                JamesBo.single().recordError(folder);
                            }
                            return true;
                        }
                    }).execute();
                }
                catch (Exception exp) {
                    Log0.error(this.getClass(), (String)exp.toString(), (Throwable)exp);
                    Msg.error((Component)JamesPanel.single(), (Object)exp.toString());
                }
                finally {
                    Startup.refreshTitle(I18N.get("version"));
                }
            } else {
                Msg.error((Component)JamesPanel.single(), (Object)MessageFormat.format(I18N.get("FMT_CANNOT_FIND"), this.pathTextField.getText()));
            }
        });
    }

    private JFileChooser createJFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new FileNameExtensionFilter(I18N.get("FILE_DESC_EXCEL"), I18N.get("FILE_SUFFIX_XLSX")));
        File currentFile = null;
        if (!Strings.isNullOrEmpty((String)this.pathTextField.getText())) {
            currentFile = File0.newFile((String[])new String[]{this.pathTextField.getText()});
        }
        if (currentFile != null && currentFile.exists()) {
            jFileChooser.setCurrentDirectory(currentFile);
        } else {
            jFileChooser.setCurrentDirectory(File0.newFile((String[])new String[]{Url0.getURL((String)String0.SLASH).getPath()}));
        }
        return jFileChooser;
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        JLabel selectPathButtion = new JLabel(I18N.get("SelectPath"));
        this.add((Component)selectPathButtion, GBC.grid((int)0, (int)0, (int)1, (int)1).weight(0.0, 0.0).anchor(13).fill(0).insets(8, 8, 1, 1));
        this.pathTextField.setEditable(false);
        this.add((Component)this.pathTextField, GBC.grid((int)1, (int)0, (int)8, (int)1).weight(8.0, 0.0).anchor(10).fill(2).insets(8, 1, 1, 1));
        this.add((Component)this.selectButton, GBC.grid((int)9, (int)0, (int)1, (int)1).weight(0.0, 0.0).anchor(17).fill(0).insets(8, 1, 1, 8));
        this.add((Component)new JPanel(), GBC.grid((int)0, (int)1, (int)4, (int)1).weight(4.0, 0.0).anchor(10).fill(2).insets(1, 8, 8, 1));
        this.add((Component)this.downloadTemplateButton, GBC.grid((int)4, (int)1, (int)1, (int)1).weight(0.0, 0.0).anchor(13).fill(0).insets(1, 1, 8, 1));
        this.add((Component)this.generateSqlButton, GBC.grid((int)5, (int)1, (int)1, (int)1).weight(0.0, 0.0).anchor(17).fill(0).insets(1, 1, 8, 1));
        this.add((Component)new JPanel(), GBC.grid((int)6, (int)1, (int)3, (int)1).weight(3.0, 0.0).anchor(10).fill(2).insets(1, 1, 8, 1));
        this.add((Component)new JPanel(), GBC.grid((int)9, (int)1, (int)1, (int)1).weight(0.0, 0.0).anchor(10).fill(0).insets(1, 1, 8, 8));
    }

    private static class SigletonHolder {
        private static final JamesPanel instance = new JamesPanel();

        private SigletonHolder() {
        }
    }
}

