/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.james.startup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.azolla.l.ling.util.Log0;
import org.azolla.p.james.i18n.I18N;
import org.azolla.p.james.panel.JamesPanel;

public class Startup {
    private static JFrame tzfeFrame = new JFrame();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Startup.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        Log0.info(Startup.class, (String)"James starting...");
        tzfeFrame.setLayout(new BorderLayout());
        tzfeFrame.add((Component)JamesPanel.single(), "Center");
        Startup.refreshTitle(I18N.get("version"));
        tzfeFrame.setSize(600, 100);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        tzfeFrame.setLocation((int)(screen.getWidth() - 600.0) / 2, (int)(screen.getHeight() - 100.0) / 2);
        tzfeFrame.setDefaultCloseOperation(3);
        tzfeFrame.setResizable(false);
        tzfeFrame.setVisible(true);
        Log0.info(Startup.class, (String)"James started");
    }

    public static void refreshTitle(String state) {
        tzfeFrame.setTitle(I18N.get("artifact") + " - " + state);
    }
}

