/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.james.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.azolla.l.ling.io.Close0;
import org.azolla.l.ling.util.Log0;
import org.azolla.p.james.bo.DBColumnBo;
import org.azolla.p.james.bo.DBTableBo;
import org.azolla.p.james.bo.ExcelColumnBo;
import org.azolla.p.james.bo.ExcelSheetBo;
import org.azolla.p.james.bo.JamesBo;
import org.azolla.p.james.converter.ConverterHelper;
import org.azolla.p.james.util.Cons;
import org.azolla.p.james.util.DBCons;
import org.azolla.p.james.util.ExcelCons;
import org.azolla.p.james.validater.ValidaterHelper;

public enum ExcelParser {
    SIGLETON;


    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseJamesExcel(File excelFile) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(excelFile);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fileInputStream);
            XSSFSheet sheet = workbook.getSheet("James.Excel");
            int rows = sheet.getPhysicalNumberOfRows();
            XSSFRow jamesExcelXSSFRow = sheet.getRow(Cons.JAMES_EXCEL_TITLE_ROW_INDEX.intValue());
            for (int colIndex = 0; colIndex < jamesExcelXSSFRow.getPhysicalNumberOfCells(); ++colIndex) {
                XSSFCell titleXSSFCell = jamesExcelXSSFRow.getCell(colIndex);
                if (titleXSSFCell == null) continue;
                if ("Sheet".equalsIgnoreCase(titleXSSFCell.toString())) {
                    ExcelCons.SHEET_COL_INDEX = colIndex;
                    continue;
                }
                if ("Column".equalsIgnoreCase(titleXSSFCell.toString())) {
                    ExcelCons.COLUMN_COL_INDEX = colIndex;
                    continue;
                }
                if ("Validater".equalsIgnoreCase(titleXSSFCell.toString())) {
                    ExcelCons.VALIDATER_COL_INDEX = colIndex;
                    continue;
                }
                if (!"Converter".equalsIgnoreCase(titleXSSFCell.toString())) continue;
                ExcelCons.CONVERTER_COL_INDEX = colIndex;
            }
            String lastSheet = null;
            String currentSheet = null;
            ExcelSheetBo excelSheetBo = null;
            for (int rowIndex = Cons.JAMES_EXCEL_TITLE_ROW_INDEX + 1; rowIndex < rows; ++rowIndex) {
                XSSFCell columnXSSFCell;
                jamesExcelXSSFRow = sheet.getRow(rowIndex);
                if (jamesExcelXSSFRow == null || (columnXSSFCell = jamesExcelXSSFRow.getCell(ExcelCons.COLUMN_COL_INDEX.intValue())) == null) continue;
                XSSFCell sheetXSSFCell = jamesExcelXSSFRow.getCell(ExcelCons.SHEET_COL_INDEX.intValue());
                XSSFCell validaterXSSFCell = jamesExcelXSSFRow.getCell(ExcelCons.VALIDATER_COL_INDEX.intValue());
                XSSFCell converterXSSFCell = jamesExcelXSSFRow.getCell(ExcelCons.CONVERTER_COL_INDEX.intValue());
                String string = currentSheet = sheetXSSFCell == null ? lastSheet : sheetXSSFCell.toString();
                if (excelSheetBo == null || !currentSheet.equalsIgnoreCase(lastSheet)) {
                    JamesBo.single().addExcelSheetBo(excelSheetBo);
                    excelSheetBo = new ExcelSheetBo().setSheet(currentSheet);
                    lastSheet = currentSheet;
                }
                ExcelColumnBo excelColumnBo = new ExcelColumnBo();
                excelColumnBo.setColumn(columnXSSFCell.toString());
                excelColumnBo.addValidaterList(validaterXSSFCell == null ? null : ValidaterHelper.parse(validaterXSSFCell.toString()));
                excelColumnBo.addConverterList(converterXSSFCell == null ? null : ConverterHelper.parse(converterXSSFCell.toString()));
                excelSheetBo.addExcelColumnBo(excelColumnBo);
            }
            JamesBo.single().addExcelSheetBo(excelSheetBo);
        }
        catch (Exception ex) {
            try {
                Log0.error(((Object)((Object)this)).getClass(), (String)ex.toString(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                Close0.close(fileInputStream);
                throw throwable;
            }
            Close0.close((Closeable)fileInputStream);
        }
        Close0.close((Closeable)fileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseJamesDB(File excelFile) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(excelFile);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fileInputStream);
            XSSFSheet sheet = workbook.getSheet("James.DB");
            int rows = sheet.getPhysicalNumberOfRows();
            XSSFRow jamesDBXSSFRow = sheet.getRow(Cons.JAMES_DB_TITLE_ROW_INDEX.intValue());
            for (int colIndex = 0; colIndex < jamesDBXSSFRow.getPhysicalNumberOfCells(); ++colIndex) {
                XSSFCell titleXSSFCell = jamesDBXSSFRow.getCell(colIndex);
                if (titleXSSFCell == null) continue;
                if ("DBTable".equalsIgnoreCase(titleXSSFCell.toString())) {
                    DBCons.DBTABLE_COL_INDEX = colIndex;
                    continue;
                }
                if ("ESheet".equalsIgnoreCase(titleXSSFCell.toString())) {
                    DBCons.ESHEET_COL_INDEX = colIndex;
                    continue;
                }
                if ("DBColumn".equalsIgnoreCase(titleXSSFCell.toString())) {
                    DBCons.DBCOLUMN_COL_INDEX = colIndex;
                    continue;
                }
                if ("EColumn".equalsIgnoreCase(titleXSSFCell.toString())) {
                    DBCons.ECOLUMN_COL_INDEX = colIndex;
                    continue;
                }
                if ("DBSeq".equalsIgnoreCase(titleXSSFCell.toString())) {
                    DBCons.DBSEQ_COL_INDEX = colIndex;
                    continue;
                }
                if ("DBColumnSql".equalsIgnoreCase(titleXSSFCell.toString())) {
                    DBCons.DBCOLUMNSQL_COL_INDEX = colIndex;
                    continue;
                }
                if ("BizKey".equalsIgnoreCase(titleXSSFCell.toString())) {
                    DBCons.BIZKEY_COL_INDEX = colIndex;
                    continue;
                }
                if ("DefaultValue".equalsIgnoreCase(titleXSSFCell.toString())) {
                    DBCons.DEFAULTVALUE_COL_INDEX = colIndex;
                    continue;
                }
                if (!"Separator".equalsIgnoreCase(titleXSSFCell.toString())) continue;
                DBCons.SEPARATOR_COL_INDEX = colIndex;
            }
            DBTableBo dbTableBo = null;
            DBColumnBo dbColumnBo = null;
            for (int rowIndex = Cons.JAMES_DB_TITLE_ROW_INDEX + 1; rowIndex < rows; ++rowIndex) {
                XSSFCell separatorXSSFCell;
                XSSFCell defaultValueXSSFCell;
                XSSFCell bizKeyXSSFCell;
                XSSFCell dbColumnSqlXSSFCell;
                XSSFCell dbSeqXSSFCell;
                XSSFCell eColumnXSSFCell;
                XSSFCell dbColumnXSSFCell;
                XSSFCell eSheetXSSFCell;
                jamesDBXSSFRow = sheet.getRow(rowIndex);
                if (jamesDBXSSFRow == null) {
                    if (dbTableBo == null) continue;
                    JamesBo.single().addDbTableBo(dbTableBo);
                    Object dbTableXSSFCell = null;
                    eSheetXSSFCell = null;
                    dbColumnXSSFCell = null;
                    eColumnXSSFCell = null;
                    dbSeqXSSFCell = null;
                    dbColumnSqlXSSFCell = null;
                    bizKeyXSSFCell = null;
                    defaultValueXSSFCell = null;
                    separatorXSSFCell = null;
                    dbTableBo = null;
                    dbColumnBo = null;
                    continue;
                }
                dbColumnXSSFCell = jamesDBXSSFRow.getCell(DBCons.DBCOLUMN_COL_INDEX.intValue());
                if (dbColumnXSSFCell == null) continue;
                XSSFCell dbTableXSSFCell = jamesDBXSSFRow.getCell(DBCons.DBTABLE_COL_INDEX.intValue());
                eSheetXSSFCell = jamesDBXSSFRow.getCell(DBCons.ESHEET_COL_INDEX.intValue());
                eColumnXSSFCell = jamesDBXSSFRow.getCell(DBCons.ECOLUMN_COL_INDEX.intValue());
                dbSeqXSSFCell = jamesDBXSSFRow.getCell(DBCons.DBSEQ_COL_INDEX.intValue());
                dbColumnSqlXSSFCell = jamesDBXSSFRow.getCell(DBCons.DBCOLUMNSQL_COL_INDEX.intValue());
                bizKeyXSSFCell = jamesDBXSSFRow.getCell(DBCons.BIZKEY_COL_INDEX.intValue());
                defaultValueXSSFCell = jamesDBXSSFRow.getCell(DBCons.DEFAULTVALUE_COL_INDEX.intValue());
                separatorXSSFCell = jamesDBXSSFRow.getCell(DBCons.SEPARATOR_COL_INDEX.intValue());
                if (dbTableBo == null) {
                    dbTableBo = new DBTableBo().setDbTable(dbTableXSSFCell.toString()).seteSheet(eSheetXSSFCell.toString());
                }
                dbColumnBo = new DBColumnBo().setDbColumn(dbColumnXSSFCell.toString());
                if (eColumnXSSFCell != null) {
                    dbColumnBo.seteColumn(eColumnXSSFCell.toString());
                }
                if (dbSeqXSSFCell != null) {
                    dbColumnBo.setDbSeq(dbSeqXSSFCell.toString());
                }
                if (dbColumnSqlXSSFCell != null) {
                    dbColumnBo.setDbColumnSql(dbColumnSqlXSSFCell.toString());
                }
                if (bizKeyXSSFCell != null) {
                    dbColumnBo.setBizKey(bizKeyXSSFCell.toString());
                }
                if (defaultValueXSSFCell != null) {
                    dbColumnBo.setDefaultValue(defaultValueXSSFCell.toString());
                }
                if (separatorXSSFCell != null) {
                    dbColumnBo.setSeparator(separatorXSSFCell.toString());
                }
                dbTableBo.addDbColumnBo(dbColumnBo);
            }
            dbTableBo.addDbColumnBo(dbColumnBo);
            JamesBo.single().addDbTableBo(dbTableBo);
        }
        catch (Exception ex) {
            try {
                Log0.error(((Object)((Object)this)).getClass(), (String)ex.toString(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                Close0.close(fileInputStream);
                throw throwable;
            }
            Close0.close((Closeable)fileInputStream);
        }
        Close0.close((Closeable)fileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseJamesData(File excelFile, ExcelSheetBo excelSheetBo) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(excelFile);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fileInputStream);
            XSSFSheet sheet = workbook.getSheet(excelSheetBo.getSheet());
            int rows = sheet.getPhysicalNumberOfRows();
            XSSFRow jamesDataXSSFRow = sheet.getRow(Cons.JAMES_DATA_TITLE_ROW_INDEX.intValue());
            int cols = jamesDataXSSFRow.getPhysicalNumberOfCells();
            block4: for (int colIndex = 0; colIndex < cols; ++colIndex) {
                XSSFCell titleXSSFCell = jamesDataXSSFRow.getCell(colIndex);
                if (titleXSSFCell == null) continue;
                for (String col : excelSheetBo.getStringExcelColumnBoMap().keySet()) {
                    if (!col.equalsIgnoreCase(titleXSSFCell.toString())) continue;
                    excelSheetBo.addStringInteger(col, colIndex);
                    continue block4;
                }
            }
            String[][] dataArray = new String[rows - Cons.JAMES_DATA_TITLE_ROW_INDEX - 1][cols];
            for (int rowIndex = Cons.JAMES_DATA_TITLE_ROW_INDEX + 1; rowIndex < rows; ++rowIndex) {
                jamesDataXSSFRow = sheet.getRow(rowIndex);
                if (jamesDataXSSFRow == null) continue;
                for (int colIndex = 0; colIndex < cols; ++colIndex) {
                    XSSFCell dataXSSFCell = jamesDataXSSFRow.getCell(colIndex);
                    if (dataXSSFCell == null) continue;
                    dataArray[rowIndex - Cons.JAMES_DATA_TITLE_ROW_INDEX.intValue() - 1][colIndex] = dataXSSFCell.toString();
                }
            }
            excelSheetBo.setDataArray(dataArray);
        }
        catch (Exception ex) {
            try {
                Log0.error(((Object)((Object)this)).getClass(), (String)ex.toString(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                Close0.close(fileInputStream);
                throw throwable;
            }
            Close0.close((Closeable)fileInputStream);
        }
        Close0.close((Closeable)fileInputStream);
    }
}

