/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.james.validater;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.azolla.p.james.validater.Validater;
import org.azolla.p.james.validater.impl.DateValidater;
import org.azolla.p.james.validater.impl.EmailValidater;
import org.azolla.p.james.validater.impl.MaxLengthValidater;
import org.azolla.p.james.validater.impl.MaxValueValidater;
import org.azolla.p.james.validater.impl.MinLengthValidater;
import org.azolla.p.james.validater.impl.MinValueValidater;
import org.azolla.p.james.validater.impl.NumberValidater;

public class ValidaterHelper {
    public static final Map<String, Validater> validaterMap = Maps.newHashMap();

    public static List<Validater> parse(String s) {
        ArrayList rtnList = Lists.newArrayList();
        if (!Strings.isNullOrEmpty((String)s)) {
            String[] validaterArray;
            for (String validaterString : validaterArray = s.split(String.valueOf(';'))) {
                String[] validateArray = validaterString.split(String.valueOf(':'));
                Validater validater = null;
                if (validateArray.length > 0) {
                    validater = validaterMap.get(validateArray[0]);
                }
                if (validater == null) continue;
                validater = validater.new0();
                if (validateArray.length > 1) {
                    validater.setFactor(validateArray[1]);
                }
                rtnList.add(validater);
            }
        }
        return rtnList;
    }

    static {
        validaterMap.put("isDate", new DateValidater());
        validaterMap.put("isEmail", new EmailValidater());
        validaterMap.put("maxLength", new MaxLengthValidater());
        validaterMap.put("maxValue", new MaxValueValidater());
        validaterMap.put("minLength", new MinLengthValidater());
        validaterMap.put("minValue", new MinValueValidater());
        validaterMap.put("isNumber", new NumberValidater());
    }
}

