/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.roc.controller;

import org.apache.ibatis.session.RowBounds;
import org.azolla.p.roc.aware.CacheAware;
import org.azolla.p.roc.dao.ICategoryDao;
import org.azolla.p.roc.service.ICategoryService;
import org.azolla.p.roc.service.IPostService;
import org.azolla.p.roc.vo.CategoryVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class CategoryController {
    @Autowired
    private IPostService iPostService;
    @Autowired
    private ICategoryService iCategoryService;
    @Autowired
    private ICategoryDao iCategoryDao;

    @RequestMapping(value={"/admin/category/opt"}, method={RequestMethod.GET})
    public String opt(Model model) {
        model.addAttribute("jsp_title", (Object)"New Category");
        model.addAttribute("categoryVo", (Object)new CategoryVo());
        return "admin/category/opt";
    }

    @RequestMapping(value={"/admin/category/lst"}, method={RequestMethod.GET})
    public String lst(Model model) {
        return this.lst(1, model);
    }

    @RequestMapping(value={"/admin/category/lst/{page}"}, method={RequestMethod.GET})
    public String lst(@PathVariable String page, Model model) {
        int requestPage = Integer.valueOf(page);
        return this.lst(requestPage, model);
    }

    private String lst(int page, Model model) {
        model.addAttribute("categoryVoList", (Object)this.iCategoryDao.fullLstWithoutVOD(new RowBounds(page, Integer.parseInt(CacheAware.getConfigValue((String)"ROC_CONFIG_KEY_POSTSIZE")))));
        model.addAttribute("current_page", (Object)page);
        model.addAttribute("current_request", (Object)"admin/category/lst");
        model.addAttribute("jsp_title", (Object)"Category List");
        return "admin/category/lst";
    }

    @RequestMapping(value={"/category/{categoryUrlName}"})
    public String category(@PathVariable String categoryUrlName, Model model) {
        model.addAttribute("postList", (Object)this.iPostService.lstByCategoryUrlName(categoryUrlName, 1));
        model.addAttribute("current_page", (Object)1);
        this.setting(categoryUrlName, model);
        return "lst";
    }

    @RequestMapping(value={"/category/{categoryUrlName}/{page}"})
    public String category(@PathVariable String categoryUrlName, @PathVariable String page, Model model) {
        int requestPage = Integer.parseInt(page);
        model.addAttribute("postList", (Object)this.iPostService.lstByCategoryUrlName(categoryUrlName, requestPage));
        model.addAttribute("current_page", (Object)requestPage);
        this.setting(categoryUrlName, model);
        return "lst";
    }

    private void setting(String categoryUrlName, Model model) {
        CategoryVo categoryVo = this.iCategoryDao.getByUrlName(categoryUrlName);
        model.addAttribute("sidebar_title", (Object)categoryVo.getDisplayName());
        model.addAttribute("current_request", (Object)("category/" + categoryUrlName));
    }
}

