/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.roc.controller;

import org.apache.ibatis.session.RowBounds;
import org.azolla.p.roc.aware.CacheAware;
import org.azolla.p.roc.dao.ITagDao;
import org.azolla.p.roc.service.IPostService;
import org.azolla.p.roc.service.ITagService;
import org.azolla.p.roc.vo.TagVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class TagController {
    @Autowired
    private IPostService iPostService;
    @Autowired
    private ITagService iTagService;
    @Autowired
    private ITagDao iTagDao;

    @RequestMapping(value={"/admin/tag/lst"}, method={RequestMethod.GET})
    public String lst(Model model) {
        return this.lst(1, model);
    }

    @RequestMapping(value={"/admin/tag/lst/{page}"}, method={RequestMethod.GET})
    public String lst(@PathVariable String page, Model model) {
        int requestPage = Integer.valueOf(page);
        return this.lst(requestPage, model);
    }

    private String lst(int page, Model model) {
        model.addAttribute("tagVoList", (Object)this.iTagDao.lstWithoutVOD(new RowBounds(page, Integer.parseInt(CacheAware.getConfigValue((String)"ROC_CONFIG_KEY_POSTSIZE")))));
        model.addAttribute("current_page", (Object)page);
        model.addAttribute("current_request", (Object)"admin/tag/lst");
        model.addAttribute("jsp_title", (Object)"Tag List");
        return "admin/tag/lst";
    }

    @RequestMapping(value={"/tag/{tag}"})
    public String tag(@PathVariable String tag, Model model) {
        model.addAttribute("postList", (Object)this.iPostService.lstByTagUrlName(tag, 1));
        model.addAttribute("current_page", (Object)1);
        this.setting(tag, model);
        return "lst";
    }

    @RequestMapping(value={"/tag/{tag}/{page}"})
    public String tag(@PathVariable String tag, @PathVariable String page, Model model) {
        int requestPage = Integer.parseInt(page);
        model.addAttribute("postList", (Object)this.iPostService.lstByTagUrlName(tag, requestPage));
        model.addAttribute("current_page", (Object)requestPage);
        this.setting(tag, model);
        return "lst";
    }

    private void setting(String tag, Model model) {
        TagVo tagVo = this.iTagDao.getByUrlName(tag);
        model.addAttribute("sidebar_title", (Object)tagVo.getDisplayName());
        model.addAttribute("current_request", (Object)("tag/" + tag));
    }
}

