/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.roc.aware;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.azolla.p.roc.dao.ITagDao;
import org.azolla.p.roc.service.ICategoryService;
import org.azolla.p.roc.service.IConfigService;
import org.azolla.p.roc.vo.CategoryVo;
import org.azolla.p.roc.vo.TagVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class CacheAware {
    public static final String CATEGORY_CACHE = "CATEGORY_MAP";
    public static final String CONFIG_CACHE = "CONFIG_MAP";
    public static final String TAG_CACHE = "TAG_LST";
    public static final String LEFT_CATEGORY_LST = "LEFT_CATEGORY_LST";
    public static final String RIGHT_CATEGORY_LST = "RIGHT_CATEGORY_LST";
    public static final String ROC_POST_SIZE = "ROC_POST_SIZE";
    public static final String ROC_DESC = "ROC_DESC";
    public static final String ROC_EMAIL = "ROC_EMAIL";
    public static final String ROC_TITLE = "ROC_TITLE";
    private static ConcurrentMap<String, List<CategoryVo>> CATEGORY_MAP = new ConcurrentHashMap();
    private static ConcurrentMap<String, String> CONFIG_MAP = new ConcurrentHashMap();
    private static List<TagVo> TAG_LIST = Lists.newArrayList();
    private static ConcurrentMap<Integer, CategoryVo> CATEGORY_ID_VO_MAP = Maps.newConcurrentMap();
    @Autowired
    private ICategoryService iCategoryService;
    @Autowired
    private IConfigService iConfigService;
    @Autowired
    private ITagDao iTagDao;

    public static List<CategoryVo> getCategoryList(String key) {
        return (List)CATEGORY_MAP.get(key);
    }

    public static String getConfigValue(String key) {
        return (String)CONFIG_MAP.get(key);
    }

    public static ConcurrentMap<String, String> getConfigMap() {
        return CONFIG_MAP;
    }

    public static List<TagVo> getTagList() {
        return TAG_LIST;
    }

    public static String getTagDisplayNameString() {
        return Joiner.on((String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ").join((Iterable)Lists.transform((List)TAG_LIST, (Function)new /* Unavailable Anonymous Inner Class!! */));
    }

    public static CategoryVo getCategoryVoById(Integer categoryId) {
        return (CategoryVo)CATEGORY_ID_VO_MAP.get(categoryId);
    }

    @PostConstruct
    private void pre() {
        this.load();
    }

    public void load() {
        this.load(CATEGORY_CACHE);
        this.load(CONFIG_CACHE);
        this.load(TAG_CACHE);
    }

    public void load(String cache) {
        this.clear(cache);
        switch (cache) {
            case "CATEGORY_MAP": {
                CATEGORY_MAP.put(LEFT_CATEGORY_LST, this.iCategoryService.lst("left"));
                CATEGORY_MAP.put(RIGHT_CATEGORY_LST, this.iCategoryService.lst("right"));
                CATEGORY_ID_VO_MAP.clear();
                for (CategoryVo categoryVo : (List)CATEGORY_MAP.get(LEFT_CATEGORY_LST)) {
                    CATEGORY_ID_VO_MAP.put(categoryVo.getId(), categoryVo);
                }
                for (CategoryVo categoryVo : (List)CATEGORY_MAP.get(RIGHT_CATEGORY_LST)) {
                    CATEGORY_ID_VO_MAP.put(categoryVo.getId(), categoryVo);
                }
                break;
            }
            case "CONFIG_MAP": {
                CONFIG_MAP.putAll(this.iConfigService.map());
                break;
            }
            case "TAG_LST": {
                TAG_LIST.addAll(this.iTagDao.lst());
                break;
            }
        }
    }

    public void reload() {
        this.reload(CATEGORY_CACHE);
        this.reload(CONFIG_CACHE);
        this.reload(TAG_CACHE);
    }

    public void reload(String cache) {
        this.clear(cache);
        this.load(cache);
    }

    public void clear() {
        this.clear(CATEGORY_CACHE);
        this.clear(CONFIG_CACHE);
        this.clear(TAG_CACHE);
    }

    public void clear(String cache) {
        switch (cache) {
            case "CATEGORY_MAP": {
                CATEGORY_MAP.clear();
                break;
            }
            case "CONFIG_MAP": {
                CONFIG_MAP.clear();
                break;
            }
            case "TAG_LST": {
                TAG_LIST.clear();
                break;
            }
        }
    }

    @PreDestroy
    private void post() {
        this.clear();
    }
}

