/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.roc.controller;

import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.azolla.l.ling.img.Img0;
import org.azolla.l.ling.io.Close0;
import org.azolla.l.ling.io.File0;
import org.azolla.l.ling.json.Json0;
import org.azolla.l.ling.lang.String0;
import org.azolla.l.ling.util.Log0;
import org.azolla.p.roc.aware.CacheAware;
import org.azolla.p.roc.service.ICommentService;
import org.azolla.p.roc.service.ITagService;
import org.azolla.p.roc.vo.CommentVo;
import org.azolla.p.roc.vo.TagVo;
import org.azolla.w.alioss.AliOss;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AjaxController {
    public static final String OSS_ROC_GENERATE_QRCODE_EMAIL_FOLDER = "roc/generate/qrcode/email/";
    @Autowired
    private ITagService iTagService;
    @Autowired
    private ICommentService iCommentService;
    @Autowired
    private CacheAware cacheAware;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/ajax/comment/add"})
    public void addComment(Integer postId, String commentName, String commentEmail, String commentContent, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = null;
        try {
            out = response.getWriter();
            JSONObject obj = new JSONObject();
            File qrcodeFolder = File0.newFile((String[])new String[]{request.getServletContext().getRealPath(String0.SLASH), OSS_ROC_GENERATE_QRCODE_EMAIL_FOLDER});
            if (!qrcodeFolder.exists()) {
                qrcodeFolder.mkdirs();
            }
            File qrcodeFile = File0.newFile((File)qrcodeFolder, (String[])new String[]{commentEmail + String0.POINT + "png"});
            CommentVo commentVo = null;
            String photoUrl = null;
            photoUrl = !qrcodeFile.exists() && Img0.qrcode((String)commentEmail, (int)64, (int)64, (Path)Paths.get(qrcodeFile.toURI())) ? AliOss.IMG.putObject(qrcodeFile, OSS_ROC_GENERATE_QRCODE_EMAIL_FOLDER) : AliOss.IMG.getOssDomain() + OSS_ROC_GENERATE_QRCODE_EMAIL_FOLDER + qrcodeFile.getName();
            commentVo = this.iCommentService.add(postId, commentName, commentEmail, photoUrl, commentContent, request);
            if (commentVo == null) {
                obj.put((Object)"err", (Object)1);
                obj.put((Object)"msg", (Object)"add failed!");
            } else {
                commentVo.setUsername(String0.html((String)commentVo.getUsername()));
                commentVo.setEmail(String0.html((String)commentVo.getEmail()));
                commentVo.setContent(String0.html((String)commentVo.getContent()));
                obj.put((Object)"err", (Object)0);
                obj.put((Object)"rst", (Object)commentVo);
            }
            out.println(Json0.object2String((Object)obj));
            out.flush();
        }
        catch (Exception e) {
            Log0.error(this.getClass(), (String)e.toString(), (Throwable)e);
        }
        finally {
            Close0.close((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @RequestMapping(value={"/ajax/lstTag"})
    public void lstTag(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = null;
        try {
            out = response.getWriter();
            out.println(JSONArray.toJSONString((List)CacheAware.getTagList()));
        }
        catch (Exception e) {
            Log0.error(this.getClass(), (String)e.toString(), (Throwable)e);
        }
        finally {
            Close0.close((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @RequestMapping(value={"/ajax/addTag/{tagDisplayName}"})
    public void addTag(@PathVariable String tagDisplayName, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = null;
        try {
            out = response.getWriter();
            JSONObject obj = new JSONObject();
            TagVo tagVo = this.iTagService.addByTagDisplayName(tagDisplayName);
            if (tagVo == null) {
                obj.put((Object)"err", (Object)1);
                obj.put((Object)"msg", (Object)"operation failed!");
            } else {
                obj.put((Object)"err", (Object)0);
                obj.put((Object)"rst", (Object)tagVo);
                this.cacheAware.reload("TAG_LST");
            }
            out.println(obj.toJSONString());
            return;
        }
        catch (Exception e) {
            Log0.error(this.getClass(), (String)e.toString(), (Throwable)e);
        }
        finally {
            Close0.close((Closeable)out);
        }
    }
}

