/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.roc.controller;

import org.apache.ibatis.session.RowBounds;
import org.azolla.l.ling.collect.Tuple;
import org.azolla.p.roc.aware.CacheAware;
import org.azolla.p.roc.dao.IConfigDao;
import org.azolla.p.roc.service.IConfigService;
import org.azolla.p.roc.vo.ConfigVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class ConfigController {
    @Autowired
    private IConfigDao iConfigDao;
    @Autowired
    private IConfigService iConfigService;

    @RequestMapping(value={"/admin/config/opt"}, method={RequestMethod.GET})
    public String opt(Model model) {
        model.addAttribute("jsp_title", (Object)"New Config");
        model.addAttribute("configVo", (Object)new ConfigVo());
        return "/admin/config/opt";
    }

    @RequestMapping(value={"/admin/config/opt/{key}"}, method={RequestMethod.GET})
    public String opt(@PathVariable String key, Model model) {
        model.addAttribute("jsp_title", (Object)"New Config");
        model.addAttribute("configVo", (Object)this.iConfigDao.getByRocKey(key));
        return "/admin/config/opt";
    }

    @RequestMapping(value={"/admin/config/opt"}, method={RequestMethod.POST})
    public String opt(int id, String rocKey, String rocValue, Integer visible, Integer operable, Model model) {
        String rtnString = "redirect:/admin/config/lst";
        Tuple.Triple serviceResult = this.iConfigService.opt(id, rocKey, rocValue, visible, operable);
        if (!((Boolean)Tuple.getFirst((Tuple)serviceResult)).booleanValue()) {
            rtnString = "admin/config/opt";
            model.addAttribute("jsp_title", (Object)(id == 0 ? "New Config" : "Mod Config"));
            model.addAttribute("ctrl_result", Tuple.getSecond((Tuple)serviceResult));
            model.addAttribute("configVo", Tuple.getThird((Tuple)serviceResult));
        }
        return rtnString;
    }

    @RequestMapping(value={"/admin/config/rmv/{id}"}, method={RequestMethod.GET})
    public String rmv(@PathVariable int id) {
        this.iConfigDao.rmvById(id);
        return "redirect:/admin/config/lst";
    }

    @RequestMapping(value={"/admin/config/lst"}, method={RequestMethod.GET})
    public String lst(Model model) {
        return this.lst(1, model);
    }

    @RequestMapping(value={"/admin/config/lst/{page}"}, method={RequestMethod.GET})
    public String lst(@PathVariable String page, Model model) {
        int requestPage = Integer.valueOf(page);
        return this.lst(requestPage, model);
    }

    private String lst(int page, Model model) {
        model.addAttribute("configVoList", (Object)this.iConfigDao.lstWithoutVOD(new RowBounds(page, Integer.parseInt(CacheAware.getConfigValue((String)"ROC_POST_SIZE")))));
        model.addAttribute("current_page", (Object)page);
        model.addAttribute("current_request", (Object)"admin/config/lst");
        model.addAttribute("jsp_title", (Object)"Config List");
        return "admin/config/lst";
    }
}

