/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.roc.controller;

import org.azolla.l.ling.collect.Tuple;
import org.azolla.p.roc.dao.IPostDao;
import org.azolla.p.roc.service.IPostService;
import org.azolla.p.roc.vo.PostVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PostController {
    @Autowired
    private IPostService iPostService;
    @Autowired
    private IPostDao iPostDao;

    @RequestMapping(value={"/admin/post/opt"}, method={RequestMethod.GET})
    public String opt(Model model) {
        model.addAttribute("jsp_title", (Object)"New Post");
        model.addAttribute("postVo", (Object)new PostVo());
        return "admin/post/opt";
    }

    @RequestMapping(value={"/admin/post/opt/{urlTitle}"}, method={RequestMethod.GET})
    public String opt(@PathVariable String urlTitle, Model model) {
        model.addAttribute("jsp_title", (Object)"Mod Post");
        model.addAttribute("postVo", (Object)this.iPostService.getByUrlTitle(urlTitle));
        return "admin/post/opt";
    }

    @RequestMapping(value={"/admin/post/opt"}, method={RequestMethod.POST})
    public String opt(int id, String title, int category, String tag, String content, Integer visible, Integer operable, Model model) {
        String rtnString = "redirect:/admin/post/lst";
        Tuple.Triple serviceResult = this.iPostService.opt(id, title, category, tag, content, visible, operable);
        if (!((Boolean)Tuple.getFirst((Tuple)serviceResult)).booleanValue()) {
            rtnString = "admin/post/opt";
            model.addAttribute("jsp_title", (Object)(id == 0 ? "New Post" : "Mod Post"));
            model.addAttribute("ctrl_result", Tuple.getSecond((Tuple)serviceResult));
            model.addAttribute("postVo", Tuple.getThird((Tuple)serviceResult));
        }
        return rtnString;
    }

    @RequestMapping(value={"/admin/post/rmv/{id}"}, method={RequestMethod.GET})
    public String rmv(@PathVariable int id) {
        this.iPostDao.rmvById(id);
        return "redirect:/admin/post/lst";
    }

    @RequestMapping(value={"/admin/post/lst"}, method={RequestMethod.GET})
    public String lst(Model model) {
        return this.lst(1, model);
    }

    @RequestMapping(value={"/admin/post/lst/{page}"}, method={RequestMethod.GET})
    public String lst(@PathVariable String page, Model model) {
        int requestPage = Integer.valueOf(page);
        return this.lst(requestPage, model);
    }

    private String lst(int page, Model model) {
        model.addAttribute("postVoList", (Object)this.iPostService.lstWithoutVOD(page));
        model.addAttribute("current_page", (Object)page);
        model.addAttribute("current_request", (Object)"admin/post/lst");
        model.addAttribute("jsp_title", (Object)"Post List");
        return "admin/post/lst";
    }

    @RequestMapping(value={"/post/{urlTile}"})
    public String post(@PathVariable String urlTile, Model model) {
        PostVo postVo = this.iPostService.getByUrlTitle(urlTile);
        model.addAttribute("post", (Object)postVo);
        model.addAttribute("jsp_title", (Object)postVo.getTitle());
        return "pst";
    }
}

