/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.roc.controller;

import org.apache.ibatis.session.RowBounds;
import org.azolla.l.ling.collect.Tuple;
import org.azolla.p.roc.aware.CacheAware;
import org.azolla.p.roc.dao.ITagDao;
import org.azolla.p.roc.service.IPostService;
import org.azolla.p.roc.service.ITagService;
import org.azolla.p.roc.vo.TagVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class TagController {
    @Autowired
    private IPostService iPostService;
    @Autowired
    private ITagService iTagService;
    @Autowired
    private ITagDao iTagDao;

    @RequestMapping(value={"/admin/tag/opt"}, method={RequestMethod.GET})
    public String opt(Model model) {
        model.addAttribute("jsp_title", (Object)"New Tag");
        model.addAttribute("tagVo", (Object)new TagVo());
        return "/admin/tag/opt";
    }

    @RequestMapping(value={"/admin/tag/opt/{urlName}"}, method={RequestMethod.GET})
    public String opt(@PathVariable String urlName, Model model) {
        model.addAttribute("jsp_title", (Object)"Mod Tag");
        model.addAttribute("tagVo", (Object)this.iTagDao.getByUrlName(urlName));
        return "/admin/tag/opt";
    }

    @RequestMapping(value={"/admin/tag/opt"}, method={RequestMethod.POST})
    public String opt(int id, String displayName, Integer visible, Integer operable, Model model) {
        String rtnString = "redirect:/admin/tag/lst";
        Tuple.Triple serviceResult = this.iTagService.opt(id, displayName, visible, operable);
        if (!((Boolean)Tuple.getFirst((Tuple)serviceResult)).booleanValue()) {
            rtnString = "admin/tag/opt";
            model.addAttribute("jsp_title", (Object)(id == 0 ? "New Tag" : "Mod Tag"));
            model.addAttribute("ctrl_result", Tuple.getSecond((Tuple)serviceResult));
            model.addAttribute("tagVo", Tuple.getThird((Tuple)serviceResult));
        }
        return rtnString;
    }

    @RequestMapping(value={"/admin/tag/rmv/{id}"}, method={RequestMethod.GET})
    public String rmv(@PathVariable int id) {
        this.iTagDao.rmvById(id);
        return "redirect:/admin/tag/lst";
    }

    @RequestMapping(value={"/admin/tag/lst"}, method={RequestMethod.GET})
    public String lst(Model model) {
        return this.lst(1, model);
    }

    @RequestMapping(value={"/admin/tag/lst/{page}"}, method={RequestMethod.GET})
    public String lst(@PathVariable String page, Model model) {
        int requestPage = Integer.valueOf(page);
        return this.lst(requestPage, model);
    }

    private String lst(int page, Model model) {
        model.addAttribute("tagVoList", (Object)this.iTagDao.lstWithoutVOD(new RowBounds(page, Integer.parseInt(CacheAware.getConfigValue((String)"ROC_POST_SIZE")))));
        model.addAttribute("current_page", (Object)page);
        model.addAttribute("current_request", (Object)"admin/tag/lst");
        model.addAttribute("jsp_title", (Object)"Tag List");
        return "admin/tag/lst";
    }

    @RequestMapping(value={"/tag/{tag}"})
    public String tag(@PathVariable String tag, Model model) {
        model.addAttribute("postList", (Object)this.iPostService.lstByTagUrlName(tag, 1));
        model.addAttribute("current_page", (Object)1);
        this.setting(tag, model);
        return "lst";
    }

    @RequestMapping(value={"/tag/{tag}/{page}"})
    public String tag(@PathVariable String tag, @PathVariable String page, Model model) {
        int requestPage = Integer.parseInt(page);
        model.addAttribute("postList", (Object)this.iPostService.lstByTagUrlName(tag, requestPage));
        model.addAttribute("current_page", (Object)requestPage);
        this.setting(tag, model);
        return "lst";
    }

    private void setting(String tag, Model model) {
        TagVo tagVo = this.iTagDao.getByUrlName(tag);
        model.addAttribute("jsp_title", (Object)tagVo.getDisplayName());
        model.addAttribute("current_request", (Object)("tag/" + tag));
    }
}

