/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.roc.dao.impl;

import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.azolla.p.roc.aware.CacheAware;
import org.azolla.p.roc.dao.IConfigDao;
import org.azolla.p.roc.vo.ConfigVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ConfigDaoImpl
implements IConfigDao {
    @Autowired
    private SqlSession sqlSession;
    @Autowired
    private CacheAware cacheAware;

    public List<ConfigVo> lstWithoutVOD(RowBounds rowBounds) {
        return this.sqlSession.selectList("mapper.config.lstWithoutVOD", null, rowBounds);
    }

    public List<ConfigVo> lst() {
        return this.sqlSession.selectList("mapper.config.lst");
    }

    public ConfigVo getByRocKey(String rocKey) {
        return (ConfigVo)this.sqlSession.selectOne("mapper.config.getByRocKey", (Object)rocKey);
    }

    public int add(ConfigVo configVo) {
        int rtn = this.sqlSession.insert("mapper.config.add", (Object)configVo);
        if (rtn > 0) {
            this.cacheAware.reload("CONFIG_MAP");
        }
        return rtn;
    }

    public int mod(ConfigVo configVo) {
        int rtn = this.sqlSession.update("mapper.config.mod", (Object)configVo);
        if (rtn > 0) {
            this.cacheAware.reload("CONFIG_MAP");
        }
        return rtn;
    }

    public int rmvById(int id) {
        int rtn = this.sqlSession.update("mapper.config.rmvById", (Object)id);
        if (rtn > 0) {
            this.cacheAware.reload("CONFIG_MAP");
        }
        return rtn;
    }
}

