/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.p.roc.service.impl;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.azolla.l.ling.collect.Tuple;
import org.azolla.l.ling.lang.Integer0;
import org.azolla.l.ling.lang.String0;
import org.azolla.l.ling.util.List0;
import org.azolla.p.roc.aware.CacheAware;
import org.azolla.p.roc.dao.ICommentDao;
import org.azolla.p.roc.dao.IPostDao;
import org.azolla.p.roc.dao.IPostRTagDao;
import org.azolla.p.roc.dao.ITagDao;
import org.azolla.p.roc.service.IPostService;
import org.azolla.p.roc.service.ITagService;
import org.azolla.p.roc.vo.PostVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PostServiceImpl
implements IPostService {
    @Autowired
    private IPostDao iPostDao;
    @Autowired
    private ITagDao iTagDao;
    @Autowired
    private ICommentDao iCommentDao;
    @Autowired
    private IPostRTagDao iPostRTagDao;
    @Autowired
    private ITagService iTagService;

    public List<PostVo> lst(int page) {
        return this.more(this.iPostDao.lst(new RowBounds(page, Integer.parseInt(CacheAware.getConfigValue((String)"ROC_POST_SIZE")))));
    }

    public List<PostVo> lstWithoutVOD(int page) {
        List rtnList = this.iPostDao.lstWithoutVOD(new RowBounds(page, Integer.parseInt(CacheAware.getConfigValue((String)"ROC_POST_SIZE"))));
        for (PostVo postVo : rtnList) {
            postVo.setCategoryVo(CacheAware.getCategoryVoById((Integer)postVo.getCategoryId()));
        }
        return rtnList;
    }

    public List<PostVo> lstByCategoryUrlName(String categoryUrlName, int page) {
        return this.more(this.iPostDao.lstByCategoryUrlName(categoryUrlName, new RowBounds(page, Integer.parseInt(CacheAware.getConfigValue((String)"ROC_POST_SIZE")))));
    }

    public List<PostVo> lstByTagUrlName(String tagUrlName, int page) {
        return this.more(this.iPostDao.lstByTagUrlName(tagUrlName, new RowBounds(page, Integer.parseInt(CacheAware.getConfigValue((String)"ROC_POST_SIZE")))));
    }

    public List<PostVo> search(String search, int page) {
        return this.more(this.iPostDao.search(search, new RowBounds(page, Integer.parseInt(CacheAware.getConfigValue((String)"ROC_POST_SIZE")))));
    }

    private List<PostVo> more(List<PostVo> lst) {
        return Lists.transform(lst, (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public PostVo getByUrlTitle(String urlTitle) {
        PostVo postVo = this.iPostDao.getByUrlTitle(urlTitle);
        postVo.getTagVoList().addAll(this.iTagDao.lstByPostUrlTitle(urlTitle));
        postVo.getCommentVoList().addAll(this.iCommentDao.lstByPostId(postVo.getId()));
        return postVo;
    }

    public Tuple.Triple<Boolean, String, PostVo> opt(int id, String title, int category, String tag, String content, Integer visible, Integer operable) {
        Tuple.Triple rtnResult = null;
        String urlTitle = String0.pinyin((String)title);
        PostVo postVo = new PostVo();
        postVo.setTitle(title);
        postVo.setUrlTitle(urlTitle);
        postVo.setCategoryId(category);
        postVo.setContent(Strings.nullToEmpty((String)content));
        postVo.setVisible(Integer0.nullToZero((Integer)visible));
        postVo.setOperable(Integer0.nullToZero((Integer)operable));
        rtnResult = Tuple.of((Object)true, null, (Object)postVo);
        if (id == 0) {
            if (this.iPostDao.getByUrlTitle(urlTitle) != null) {
                rtnResult = Tuple.of((Object)false, (Object)"Title exist!", (Object)postVo);
            } else {
                this.iPostDao.add(postVo);
                postVo.setId(this.iPostDao.getByUrlTitle(urlTitle).getId());
            }
        } else {
            this.iPostRTagDao.rmvByPostId(id);
            postVo.setId(id);
            this.iPostDao.mod(postVo);
        }
        if (((Boolean)Tuple.getFirst((Tuple)rtnResult)).booleanValue()) {
            List cachedTagIdList = Lists.transform((List)CacheAware.getTagList(), (Function)new /* Unavailable Anonymous Inner Class!! */);
            ArrayList tagIdList = Lists.newArrayList();
            ArrayList optTagList = Lists.newArrayList();
            if (!Strings.isNullOrEmpty((String)tag)) {
                optTagList.addAll(Arrays.asList(tag.split(",")));
                tagIdList.addAll(Lists.transform((List)List0.listExistInOther((List)optTagList, (List)cachedTagIdList), (Function)new /* Unavailable Anonymous Inner Class!! */));
            }
            tagIdList.addAll(Lists.transform((List)this.iTagService.btAddByTagDisplayName(List0.listNotExistInOther((List)optTagList, (List)cachedTagIdList)), (Function)new /* Unavailable Anonymous Inner Class!! */));
            List postRTagVoList = Lists.transform((List)tagIdList, (Function)new /* Unavailable Anonymous Inner Class!! */);
            this.iPostRTagDao.btAdd(postRTagVoList);
        }
        return rtnResult;
    }
}

