/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.w.leon.cfg;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.azolla.l.ling.io.Close0;
import org.azolla.l.ling.util.KV;
import org.azolla.l.ling.util.Log0;
import org.azolla.w.leon.cfg.WebCfg;

public class PropCfg
implements WebCfg {
    private String fileName = null;
    private Properties prop = new Properties();
    private LoadingCache<String, String> cfgCacheBuilder = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

        public String load(@Nonnull String key) throws Exception {
            return PropCfg.this.prop.getProperty(key);
        }
    });

    private PropCfg(String fileName) {
        this.fileName = fileName;
        this.refresh();
    }

    public static PropCfg cfg(String fileName) {
        return new PropCfg(fileName);
    }

    public String get(String key) {
        try {
            return (String)this.cfgCacheBuilder.get((Object)key);
        }
        catch (Exception e) {
            Log0.error(this.getClass(), (String)e.toString(), (Throwable)e);
            throw new RuntimeException("Can't find {" + key + "}.");
        }
    }

    @Override
    public void refresh() {
        this.refresh(this.fileName);
        try {
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            try {
                this.prop = new Properties();
                fileReader = new FileReader((File)cfgFileCacheBuilder.get((Object)this.fileName));
                bufferedReader = new BufferedReader(fileReader);
                this.prop.load(bufferedReader);
            }
            catch (Exception e) {
                try {
                    Log0.error(this.getClass(), (String)e.toString(), (Throwable)e);
                    throw new RuntimeException(e.toString());
                }
                catch (Throwable throwable) {
                    Close0.close(bufferedReader);
                    Close0.close(fileReader);
                    throw throwable;
                }
            }
            Close0.close((Closeable)bufferedReader);
            Close0.close((Closeable)fileReader);
        }
        catch (Exception e) {
            Log0.error(PropCfg.class, (String)KV.ins((String)"fileName", (String)this.fileName).toString(), (Throwable)e);
            throw new RuntimeException("Can't find {" + this.fileName + "}.");
        }
        this.cfgCacheBuilder.cleanUp();
    }
}

