/*
 * Decompiled with CFR 0.152.
 */
package org.azolla.w.leon.cfg;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.util.List;
import javax.annotation.Nonnull;
import org.azolla.l.ling.io.File0;

public interface WebCfg {
    public static final String REGULAR_CFG_FILENAME = "^(.)*\\.Azolla\\.(properties|xml)$";
    public static final LoadingCache<String, File> cfgFileCacheBuilder = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, File>(){

        public File load(@Nonnull String key) throws Exception {
            List rtnList = File0.allFile((File)WebCfg.getWebINF(), pathname -> pathname.getName().matches(WebCfg.REGULAR_CFG_FILENAME) && key.equals(pathname.getName()));
            if (rtnList.size() > 1) {
                throw new Exception("Get more then one file with {" + key + "} error.");
            }
            return (File)rtnList.get(0);
        }
    });

    public static File getWebINF() {
        String thisClassPath = WebCfg.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (thisClassPath.indexOf("WEB-INF") <= 0) {
            throw new RuntimeException("Get web root path error.");
        }
        return File0.newFile((String[])new String[]{thisClassPath.substring(0, thisClassPath.indexOf("WEB-INF") + 8)});
    }

    default public void refresh(String key) {
        cfgFileCacheBuilder.refresh((Object)key);
    }

    public void refresh();
}

