/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.reference;

import java.util.EnumSet;
import java.util.List;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.NodePath;
import org.azyva.dragom.reference.Reference;
import org.azyva.dragom.reference.ReferencePath;

public interface ReferenceGraph {
    public boolean moduleVersionExists(ModuleVersion var1);

    public List<ModuleVersion> getListModuleVersionRoot();

    public boolean isRootModuleVersion(ModuleVersion var1);

    public List<ModuleVersion> getListModuleVersionMatched();

    public boolean isMatchedModuleVersion(ModuleVersion var1);

    public List<ModuleVersion> getListModuleVersion(NodePath var1);

    public List<Referrer> getListReferrer(ModuleVersion var1);

    public List<Reference> getListReference(ModuleVersion var1);

    public boolean traverseReferenceGraph(ModuleVersion var1, boolean var2, ReentryMode var3, Visitor var4);

    public boolean visitLeafModuleVersionReferencePaths(ModuleVersion var1, Visitor var2);

    public void addRootModuleVersion(ModuleVersion var1);

    public void addReference(ModuleVersion var1, Reference var2);

    public void addMatchedReferencePath(ReferencePath var1);

    public static interface Visitor {
        public VisitControl visit(ReferenceGraph var1, ReferencePath var2, EnumSet<VisitAction> var3);
    }

    public static enum VisitControl {
        CONTINUE,
        ABORT,
        SKIP_CHILDREN,
        SKIP_CURRENT_ROOT;

    }

    public static enum VisitAction {
        STEP_IN,
        STEP_OUT,
        VISIT,
        REPEATED,
        MATCHED;

        public static final EnumSet<VisitAction> ENUM_SET_STEP_IN;
        public static final EnumSet<VisitAction> ENUM_SET_STEP_OUT;
        public static final EnumSet<VisitAction> ENUM_SET_VISIT;
        public static final EnumSet<VisitAction> ENUM_SET_REPEATED_VISIT;
        public static final EnumSet<VisitAction> ENUM_SET_VISIT_MATCHED;
        public static final EnumSet<VisitAction> ENUM_SET_REPEATED_VISIT_MATCHED;

        static {
            ENUM_SET_STEP_IN = EnumSet.of(STEP_IN);
            ENUM_SET_STEP_OUT = EnumSet.of(STEP_OUT);
            ENUM_SET_VISIT = EnumSet.of(VISIT);
            ENUM_SET_REPEATED_VISIT = EnumSet.of(VISIT, REPEATED);
            ENUM_SET_VISIT_MATCHED = EnumSet.of(VISIT, MATCHED);
            ENUM_SET_REPEATED_VISIT_MATCHED = EnumSet.of(VISIT, REPEATED, MATCHED);
        }
    }

    public static enum ReentryMode {
        REENTRY,
        ONLY_PARENT,
        NO_REENTRY;

    }

    public static class Referrer {
        private ModuleVersion moduleVersion;
        private Reference reference;

        public Referrer(ModuleVersion moduleVersion, Reference reference) {
            this.moduleVersion = moduleVersion;
            this.reference = reference;
        }

        public ModuleVersion getModuleVersion() {
            return this.moduleVersion;
        }

        public Reference getReference() {
            return this.reference;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.moduleVersion.hashCode();
            result = 31 * result + this.reference.hashCode();
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof Referrer)) {
                return false;
            }
            Referrer referrerOther = (Referrer)other;
            if (!this.moduleVersion.equals(referrerOther.moduleVersion)) {
                return false;
            }
            return this.reference.equals(referrerOther.reference);
        }
    }
}

