/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.reference;

import java.util.ArrayList;
import java.util.List;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.reference.Reference;

public class ReferencePath {
    private List<Reference> listReference;

    public ReferencePath() {
        this.listReference = new ArrayList<Reference>();
    }

    public ReferencePath(ReferencePath referencePath) {
        this.listReference = new ArrayList<Reference>(referencePath.listReference);
    }

    public void add(Reference reference) {
        for (Reference reference2 : this.listReference) {
            if (!reference2.getModuleVersion().getNodePath().equals(reference.getModuleVersion().getNodePath())) continue;
            throw new RuntimeException("Cycle detected in ReferencePath " + this + " when adding Reference " + reference + '.');
        }
        this.listReference.add(reference);
    }

    public void add(ReferencePath referencePath) {
        for (int i = 0; i < referencePath.size(); ++i) {
            this.add(referencePath.get(i));
        }
    }

    public int size() {
        return this.listReference.size();
    }

    public Reference get(int index) {
        return this.listReference.get(index);
    }

    public void removeRootReference() {
        this.listReference.remove(0);
    }

    public void removeRootReferences(int nbReferences) {
        this.listReference.subList(0, nbReferences).clear();
    }

    public Reference getLeafReference() {
        return this.listReference.get(this.listReference.size() - 1);
    }

    public ModuleVersion getLeafModuleVersion() {
        return this.listReference.get(this.listReference.size() - 1).getModuleVersion();
    }

    public void removeLeafReference() {
        this.listReference.remove(this.listReference.size() - 1);
    }

    public void removeLeafReferences(int nbReferences) {
        this.listReference.subList(this.listReference.size() - nbReferences, nbReferences).clear();
    }

    public int findModuleVersion(ModuleVersion moduleVersion) {
        for (int i = 0; i < this.listReference.size(); ++i) {
            ModuleVersion moduleVersion2 = this.listReference.get(i).getModuleVersion();
            if (moduleVersion2 == null || !moduleVersion2.getNodePath().equals(moduleVersion.getNodePath()) || moduleVersion.getVersion() != null && !moduleVersion2.getVersion().equals(moduleVersion.getVersion())) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean indFirst = true;
        for (Reference reference : this.listReference) {
            if (!indFirst) {
                if (reference.getImplData() == null) {
                    stringBuilder.append("|>");
                } else {
                    stringBuilder.append("->");
                }
            }
            stringBuilder.append(reference.toString());
            indFirst = false;
        }
        return stringBuilder.toString();
    }
}

