/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.reference;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.azyva.dragom.model.ArtifactGroupId;
import org.azyva.dragom.model.ArtifactVersion;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.NodePath;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.reference.Reference;
import org.azyva.dragom.reference.ReferencePath;
import org.azyva.dragom.reference.ReferencePathMatcher;

public class ReferencePathMatcherByElement
implements ReferencePathMatcher {
    private static final String MSG_PATTERN_KEY_ELEMENT_EMPTY = "ELEMENT_EMPTY";
    private static final String MSG_PATTERN_KEY_ELEMENT_NOT_PROPERTY_TERMINATED = "ELEMENT_NOT_PROPERTY_TERMINATED";
    private static final String MSG_PATTERN_KEY_ELEMENT_REGEX_NOT_PROPERLY_TERMINATED = "ELEMENT_REGEX_NOT_PROPERLY_TERMINATED";
    private static final String MSG_PATTERN_KEY_ELEMENT_REGEX_INVALID = "ELEMENT_REGEX_INVALID";
    private static final String MSG_PATTERN_KEY_ELEMENT_ARTIFACT_NO_MODULE = "ELEMENT_ARTIFACT_NO_MODULE";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(ReferencePathMatcherByElement.class.getName() + "ResourceBundle");
    private Model model;
    private List<ElementMatcher> listElementMatcher;
    private boolean indFixedLength;
    private int fixedLength;
    private int indexFirstDoubleAsterisk;
    private int indexLastDoubleAsterisk;
    private List<ElementMatcherGroup> listElementMatcherGroup;
    private List<ModuleMatcher> listModuleMatcher;

    private ReferencePathMatcherByElement() {
    }

    public ReferencePathMatcherByElement(String stringReferencePathMatcherByElement, Model model) {
        try {
            int indexEndElementMatcher;
            this.model = model;
            this.listElementMatcher = new ArrayList<ElementMatcher>();
            this.indFixedLength = true;
            int indexStartElementMatcher = 0;
            do {
                ElementMatcher elementMatcher;
                if ((indexEndElementMatcher = stringReferencePathMatcherByElement.indexOf("->", indexStartElementMatcher)) == -1) {
                    indexEndElementMatcher = stringReferencePathMatcherByElement.length();
                }
                if ((elementMatcher = ElementMatcher.parse(stringReferencePathMatcherByElement, indexStartElementMatcher, indexEndElementMatcher)).indDoubleAsterisk) {
                    this.indFixedLength = false;
                } else {
                    ++this.fixedLength;
                }
                this.listElementMatcher.add(elementMatcher);
                indexStartElementMatcher = indexEndElementMatcher + 2;
            } while (indexEndElementMatcher != stringReferencePathMatcherByElement.length());
            this.init();
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    public static ReferencePathMatcherByElement parse(String stringReferencePathMatcherByElement, Model model) throws ParseException {
        try {
            return new ReferencePathMatcherByElement(stringReferencePathMatcherByElement, model);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ParseException) {
                throw (ParseException)re.getCause();
            }
            throw re;
        }
    }

    private void init() throws ParseException {
        int index;
        for (index = 0; index < this.listElementMatcher.size() && !this.listElementMatcher.get(index).indDoubleAsterisk; ++index) {
        }
        if (index != this.listElementMatcher.size()) {
            this.indexFirstDoubleAsterisk = index;
            for (index = this.listElementMatcher.size() - 1; index >= 0 && !this.listElementMatcher.get(index).indDoubleAsterisk; --index) {
            }
            if (index < this.indexFirstDoubleAsterisk) {
                throw new RuntimeException("Must not get here.");
            }
            this.indexLastDoubleAsterisk = index;
        } else {
            this.indexFirstDoubleAsterisk = this.listElementMatcher.size();
        }
        this.listElementMatcherGroup = new ArrayList<ElementMatcherGroup>();
        for (index = this.indexFirstDoubleAsterisk; index < this.indexLastDoubleAsterisk; ++index) {
            ElementMatcherGroup elementMatcherGroup;
            if (this.listElementMatcher.get(index).indDoubleAsterisk) {
                elementMatcherGroup = new ElementMatcherGroup();
                elementMatcherGroup.indexFirstElementMatcher = index + 1;
                this.listElementMatcherGroup.add(elementMatcherGroup);
                continue;
            }
            elementMatcherGroup = this.listElementMatcherGroup.get(this.listElementMatcherGroup.size() - 1);
            elementMatcherGroup.nbElementMatchers++;
            for (ElementMatcherGroup elementMatcherGroup2 : this.listElementMatcherGroup) {
                elementMatcherGroup2.nbTotalElementMatchers++;
            }
        }
        this.listModuleMatcher = new ArrayList<ModuleMatcher>();
        ModuleMatcher moduleMatcher = null;
        for (index = 0; index < this.listElementMatcher.size(); ++index) {
            ElementMatcher elementMatcher;
            if (moduleMatcher == null) {
                moduleMatcher = new ModuleMatcher();
            }
            if ((elementMatcher = this.listElementMatcher.get(index)).indDoubleAsterisk) {
                moduleMatcher.maxPrecedingElements = -1;
                continue;
            }
            if (elementMatcher.indAsterisk) {
                ++moduleMatcher.minPrecedingElements;
                continue;
            }
            if (elementMatcher.indSpecificModule) {
                if (elementMatcher.nodePath != null) {
                    moduleMatcher.nodePath = elementMatcher.nodePath;
                } else {
                    ArtifactGroupId artifactGroupId = new ArtifactGroupId(elementMatcher.groupId, elementMatcher.artifactId);
                    Module module = this.model.findModuleByArtifactGroupId(artifactGroupId);
                    if (module == null) {
                        throw new ParseException(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ELEMENT_ARTIFACT_NO_MODULE), this, elementMatcher, artifactGroupId), 0);
                    }
                    moduleMatcher.nodePath = module.getNodePath();
                }
                moduleMatcher.indexElementMatcher = index;
                this.listModuleMatcher.add(moduleMatcher);
                moduleMatcher = null;
                continue;
            }
            ++moduleMatcher.minPrecedingElements;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ElementMatcher elementMatcher : this.listElementMatcher) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("->");
            }
            stringBuilder.append(elementMatcher.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean matches(ReferencePath referencePath) {
        int index;
        if (this.indFixedLength && this.listElementMatcher.size() != referencePath.size()) {
            return false;
        }
        if (this.fixedLength > referencePath.size()) {
            return false;
        }
        for (index = 0; index < this.indexFirstDoubleAsterisk; ++index) {
            if (this.listElementMatcher.get(index).matches(referencePath.get(index))) continue;
            return false;
        }
        if (index == this.listElementMatcher.size()) {
            return true;
        }
        index = 0;
        while (this.listElementMatcher.size() - index - 1 > this.indexLastDoubleAsterisk) {
            if (!this.listElementMatcher.get(this.listElementMatcher.size() - index - 1).matches(referencePath.get(referencePath.size() - index - 1))) {
                return false;
            }
            ++index;
        }
        if (index == this.indexFirstDoubleAsterisk) {
            return true;
        }
        int indexElement = this.indexFirstDoubleAsterisk + 1;
        block2: for (ElementMatcherGroup elementMatcherGroup : this.listElementMatcherGroup) {
            while (indexElement + elementMatcherGroup.nbTotalElementMatchers <= this.indexLastDoubleAsterisk) {
                block11: {
                    for (index = 0; index < elementMatcherGroup.nbElementMatchers; ++index) {
                        if (this.listElementMatcher.get(elementMatcherGroup.indexFirstElementMatcher + index).matches(referencePath.get(indexElement + index))) {
                            continue;
                        }
                        break block11;
                    }
                    indexElement += elementMatcherGroup.nbElementMatchers;
                    continue block2;
                }
                ++indexElement;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean canMatchChildren(ReferencePath referencePath) {
        int indexElement;
        int indexModuleMatcher;
        ReferencePath referencePathCopy = new ReferencePath(referencePath);
        int indexTrailingElementMatcher = 0;
        for (indexModuleMatcher = 0; indexModuleMatcher < this.listModuleMatcher.size(); ++indexModuleMatcher) {
            ModuleMatcher moduleMatcher;
            block11: {
                moduleMatcher = this.listModuleMatcher.get(indexModuleMatcher);
                for (indexElement = 0; indexElement < referencePathCopy.size(); ++indexElement) {
                    if (moduleMatcher.maxPrecedingElements != -1 && indexElement > moduleMatcher.maxPrecedingElements) {
                        return false;
                    }
                    if (!referencePathCopy.get(indexElement).getModuleVersion().getNodePath().equals(moduleMatcher.nodePath)) continue;
                    if (indexElement < moduleMatcher.minPrecedingElements) {
                        return false;
                    }
                    break block11;
                }
                if (moduleMatcher.maxPrecedingElements == -1 || indexElement <= moduleMatcher.maxPrecedingElements) break;
                return false;
            }
            referencePathCopy.removeRootReferences(indexElement + 1);
            indexTrailingElementMatcher = moduleMatcher.indexElementMatcher + 1;
        }
        while (indexModuleMatcher < this.listModuleMatcher.size()) {
            for (indexElement = 0; indexElement < referencePath.size(); ++indexElement) {
                if (!referencePath.get(indexElement).getModuleVersion().getNodePath().equals(this.listModuleMatcher.get((int)indexModuleMatcher).nodePath)) continue;
                return false;
            }
            ++indexModuleMatcher;
        }
        int nbFollowingElements = 0;
        for (int index = indexTrailingElementMatcher; index < this.listElementMatcher.size(); ++index) {
            if (this.listElementMatcher.get(index).indDoubleAsterisk) {
                nbFollowingElements = -1;
                break;
            }
            ++nbFollowingElements;
        }
        if (nbFollowingElements != -1 && nbFollowingElements <= referencePathCopy.size()) {
            return false;
        }
        ReferencePathMatcherByElement referencePathMatcherByElementPrefix = new ReferencePathMatcherByElement();
        referencePathMatcherByElementPrefix.model = this.model;
        referencePathMatcherByElementPrefix.listElementMatcher = new ArrayList<ElementMatcher>(this.listElementMatcher.subList(0, indexTrailingElementMatcher));
        ElementMatcher elementMatcherDoubleAsterisk = new ElementMatcher();
        elementMatcherDoubleAsterisk.indDoubleAsterisk = true;
        referencePathMatcherByElementPrefix.listElementMatcher.add(elementMatcherDoubleAsterisk);
        try {
            referencePathMatcherByElementPrefix.init();
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        return referencePathMatcherByElementPrefix.matches(referencePath);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReferencePathMatcherByElement)) {
            return false;
        }
        ReferencePathMatcherByElement referencePathMatcherByElementOther = (ReferencePathMatcherByElement)other;
        return this.listElementMatcher.equals(referencePathMatcherByElementOther.listElementMatcher);
    }

    private static class ModuleMatcher {
        NodePath nodePath;
        int minPrecedingElements;
        int maxPrecedingElements;
        int indexElementMatcher;

        private ModuleMatcher() {
        }
    }

    private static class ElementMatcherGroup {
        private int indexFirstElementMatcher;
        private int nbElementMatchers;
        private int nbTotalElementMatchers;

        private ElementMatcherGroup() {
        }
    }

    private static class ElementMatcher {
        private boolean indAsterisk;
        private boolean indDoubleAsterisk;
        private boolean indSpecificModule;
        private NodePath nodePath;
        private Pattern patternLiteralNodePath;
        private Version version;
        private Pattern patternLiteralVersion;
        private String groupId;
        private Pattern patternGroupId;
        private String artifactId;
        private Pattern patternArtifactId;
        private ArtifactVersion artifactVersion;
        private Pattern patternLiteralArtifactVersion;

        private ElementMatcher() {
        }

        private static ElementMatcher parse(String stringReferencePathMatcherByElement, int indexStart, int indexEnd) throws ParseException {
            ElementMatcher elementMatcher = new ElementMatcher();
            PartMatcher partMatcher = new PartMatcher();
            int indexStartParse = indexStart;
            if (indexStart == indexEnd) {
                throw new ParseException(MessageFormat.format(resourceBundle.getString(ReferencePathMatcherByElement.MSG_PATTERN_KEY_ELEMENT_EMPTY), stringReferencePathMatcherByElement, indexStart), indexStart);
            }
            if (stringReferencePathMatcherByElement.substring(indexStart, indexEnd).equals("*")) {
                elementMatcher.indAsterisk = true;
            } else if (stringReferencePathMatcherByElement.substring(indexStart, indexEnd).equals("**")) {
                elementMatcher.indDoubleAsterisk = true;
            } else {
                if (stringReferencePathMatcherByElement.charAt(indexStartParse) == '/') {
                    indexStartParse = ElementMatcher.parsePart(stringReferencePathMatcherByElement, indexStartParse + 1, indexEnd, partMatcher);
                    if (partMatcher.string != null) {
                        elementMatcher.nodePath = NodePath.parse(partMatcher.string);
                    }
                    elementMatcher.patternLiteralNodePath = partMatcher.pattern;
                    if (indexStartParse != indexEnd) {
                        indexStartParse = ElementMatcher.parsePart(stringReferencePathMatcherByElement, indexStartParse, indexEnd, partMatcher);
                        if (partMatcher.string != null) {
                            elementMatcher.version = Version.parse(partMatcher.string);
                        }
                        elementMatcher.patternLiteralVersion = partMatcher.pattern;
                    }
                    if (elementMatcher.nodePath != null) {
                        elementMatcher.indSpecificModule = true;
                    }
                    if (elementMatcher.nodePath == null && elementMatcher.patternLiteralNodePath == null && elementMatcher.version == null && elementMatcher.patternLiteralVersion == null) {
                        elementMatcher.indAsterisk = true;
                    }
                } else {
                    indexStartParse = ElementMatcher.parsePart(stringReferencePathMatcherByElement, indexStartParse, indexEnd, partMatcher);
                    elementMatcher.groupId = partMatcher.string;
                    elementMatcher.patternGroupId = partMatcher.pattern;
                    if (indexStartParse != indexEnd) {
                        indexStartParse = ElementMatcher.parsePart(stringReferencePathMatcherByElement, indexStartParse, indexEnd, partMatcher);
                        elementMatcher.artifactId = partMatcher.string;
                        elementMatcher.patternArtifactId = partMatcher.pattern;
                        if (indexStartParse != indexEnd) {
                            indexStartParse = ElementMatcher.parsePart(stringReferencePathMatcherByElement, indexStartParse, indexEnd, partMatcher);
                            if (partMatcher.string != null) {
                                elementMatcher.artifactVersion = ArtifactVersion.parse(partMatcher.string);
                            }
                            elementMatcher.patternLiteralArtifactVersion = partMatcher.pattern;
                        }
                    }
                    if (elementMatcher.groupId != null && elementMatcher.artifactId != null) {
                        elementMatcher.indSpecificModule = true;
                    }
                    if (elementMatcher.groupId == null && elementMatcher.patternGroupId == null && elementMatcher.artifactId == null && elementMatcher.patternArtifactId == null && elementMatcher.artifactVersion == null && elementMatcher.patternLiteralArtifactVersion == null) {
                        elementMatcher.indAsterisk = true;
                    }
                }
                if (indexStartParse != indexEnd) {
                    throw new ParseException(MessageFormat.format(resourceBundle.getString(ReferencePathMatcherByElement.MSG_PATTERN_KEY_ELEMENT_NOT_PROPERTY_TERMINATED), stringReferencePathMatcherByElement, indexStart, indexEnd, indexStartParse), indexStartParse);
                }
            }
            return elementMatcher;
        }

        public String toString() {
            if (this.indDoubleAsterisk) {
                return "**";
            }
            if (this.indAsterisk) {
                return "*";
            }
            if (this.nodePath != null || this.patternLiteralNodePath != null || this.version != null || this.patternLiteralVersion != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('/');
                if (this.nodePath != null) {
                    stringBuilder.append(this.nodePath);
                } else if (this.patternLiteralNodePath != null) {
                    stringBuilder.append('(').append(this.patternLiteralNodePath).append(')');
                }
                if (this.version != null) {
                    stringBuilder.append(':');
                    stringBuilder.append(this.version);
                } else if (this.patternLiteralVersion != null) {
                    stringBuilder.append(':');
                    stringBuilder.append('(').append(this.patternLiteralVersion).append(')');
                }
                return stringBuilder.toString();
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (this.groupId != null) {
                stringBuilder.append(this.groupId);
            } else if (this.patternGroupId != null) {
                stringBuilder.append('(').append(this.patternGroupId).append(')');
            }
            if (this.artifactId != null) {
                stringBuilder.append(':');
                stringBuilder.append(this.artifactId);
            } else if (this.patternArtifactId != null) {
                stringBuilder.append(':');
                stringBuilder.append('(').append(this.patternArtifactId).append(')');
            }
            if (this.artifactVersion != null) {
                stringBuilder.append(':');
                stringBuilder.append(this.artifactVersion);
            } else if (this.patternLiteralArtifactVersion != null) {
                stringBuilder.append(':');
                stringBuilder.append('(').append(this.patternLiteralArtifactVersion).append(')');
            }
            return stringBuilder.toString();
        }

        private static int parsePart(String stringReferencePathMatcherByElement, int indexStart, int indexEnd, PartMatcher partMatcher) throws ParseException {
            String string;
            if (stringReferencePathMatcherByElement.charAt(indexStart) == '(') {
                String regex;
                int indexPartEnd = stringReferencePathMatcherByElement.indexOf("):", indexStart);
                if (indexPartEnd == -1) {
                    if (stringReferencePathMatcherByElement.charAt(indexEnd - 1) != ')') {
                        throw new ParseException(MessageFormat.format(resourceBundle.getString(ReferencePathMatcherByElement.MSG_PATTERN_KEY_ELEMENT_REGEX_NOT_PROPERLY_TERMINATED), stringReferencePathMatcherByElement, indexStart, indexEnd), indexEnd);
                    }
                    regex = stringReferencePathMatcherByElement.substring(indexStart + 1, indexEnd - 1);
                    indexPartEnd = indexEnd;
                } else {
                    regex = stringReferencePathMatcherByElement.substring(indexStart + 1, indexPartEnd);
                    indexPartEnd += 2;
                }
                partMatcher.string = null;
                if (regex.length() == 0) {
                    partMatcher.pattern = null;
                } else {
                    try {
                        partMatcher.pattern = Pattern.compile(regex);
                    }
                    catch (PatternSyntaxException pse) {
                        throw new ParseException(MessageFormat.format(resourceBundle.getString(ReferencePathMatcherByElement.MSG_PATTERN_KEY_ELEMENT_REGEX_INVALID), stringReferencePathMatcherByElement, indexStart + 1, indexEnd, pse.getDescription(), indexStart + 1 + pse.getIndex()), indexStart + 1 + pse.getIndex());
                    }
                }
                return indexPartEnd;
            }
            int indexPartEnd = stringReferencePathMatcherByElement.indexOf(58, indexStart);
            if (indexPartEnd == -1 || indexPartEnd > indexEnd) {
                indexPartEnd = indexEnd;
            }
            if ((string = stringReferencePathMatcherByElement.substring(indexStart, indexPartEnd)).length() == 0) {
                partMatcher.string = null;
            } else {
                partMatcher.string = string;
            }
            partMatcher.pattern = null;
            if (indexPartEnd == indexEnd) {
                return indexPartEnd;
            }
            return indexPartEnd + 1;
        }

        private boolean matches(Reference reference) {
            Matcher matcher;
            if (this.indDoubleAsterisk) {
                throw new RuntimeException("Method called for a \"**\" matcher.");
            }
            if (this.indAsterisk) {
                return true;
            }
            if (this.nodePath != null && !this.nodePath.equals(reference.getModuleVersion().getNodePath())) {
                return false;
            }
            if (this.patternLiteralNodePath != null && !(matcher = this.patternLiteralNodePath.matcher(reference.getModuleVersion().getNodePath().toString())).matches()) {
                return false;
            }
            if (this.version != null && !this.version.equals(reference.getModuleVersion().getVersion())) {
                return false;
            }
            if (this.patternLiteralVersion != null && !(matcher = this.patternLiteralVersion.matcher(reference.getModuleVersion().getVersion().toString())).matches()) {
                return false;
            }
            if (this.groupId != null) {
                if (reference.getArtifactGroupId() == null) {
                    return false;
                }
                if (!this.groupId.equals(reference.getArtifactGroupId().getGroupId())) {
                    return false;
                }
            }
            if (this.patternGroupId != null) {
                if (reference.getArtifactGroupId() == null) {
                    return false;
                }
                matcher = this.patternGroupId.matcher(reference.getArtifactGroupId().getGroupId());
                if (!matcher.matches()) {
                    return false;
                }
            }
            if (this.artifactId != null) {
                if (reference.getArtifactGroupId() == null) {
                    return false;
                }
                if (!this.artifactId.equals(reference.getArtifactGroupId().getArtifactId())) {
                    return false;
                }
            }
            if (this.patternArtifactId != null) {
                if (reference.getArtifactGroupId() == null) {
                    return false;
                }
                matcher = this.patternArtifactId.matcher(reference.getArtifactGroupId().getArtifactId());
                if (!matcher.matches()) {
                    return false;
                }
            }
            if (this.artifactVersion != null) {
                if (reference.getArtifactVersion() == null) {
                    return false;
                }
                if (!this.artifactVersion.equals(reference.getArtifactVersion())) {
                    return false;
                }
            }
            if (this.patternLiteralArtifactVersion != null) {
                if (reference.getArtifactVersion() == null) {
                    return false;
                }
                matcher = this.patternLiteralArtifactVersion.matcher(reference.getArtifactVersion().toString());
                if (!matcher.matches()) {
                    return false;
                }
            }
            return true;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof ElementMatcher)) {
                return false;
            }
            ElementMatcher elementMatcherOther = (ElementMatcher)other;
            if (this.indAsterisk != elementMatcherOther.indAsterisk) {
                return false;
            }
            if (this.indDoubleAsterisk != elementMatcherOther.indDoubleAsterisk) {
                return false;
            }
            if (this.indSpecificModule != elementMatcherOther.indSpecificModule) {
                return false;
            }
            if (this.nodePath == null ? elementMatcherOther.nodePath != null : !this.nodePath.equals(elementMatcherOther.nodePath)) {
                return false;
            }
            if (this.patternLiteralNodePath == null ? elementMatcherOther.patternLiteralNodePath != null : !this.patternLiteralNodePath.toString().equals(elementMatcherOther.patternLiteralNodePath.toString())) {
                return false;
            }
            if (this.version == null ? elementMatcherOther.version != null : !this.version.equals(elementMatcherOther.version)) {
                return false;
            }
            if (this.patternLiteralVersion == null ? elementMatcherOther.patternLiteralVersion != null : !this.patternLiteralVersion.toString().equals(elementMatcherOther.patternLiteralVersion.toString())) {
                return false;
            }
            if (this.groupId == null ? elementMatcherOther.groupId != null : !this.groupId.equals(elementMatcherOther.groupId)) {
                return false;
            }
            if (this.patternGroupId == null ? elementMatcherOther.patternGroupId != null : !this.patternGroupId.toString().equals(elementMatcherOther.patternGroupId.toString())) {
                return false;
            }
            if (this.artifactId == null ? elementMatcherOther.artifactId != null : !this.artifactId.equals(elementMatcherOther.artifactId)) {
                return false;
            }
            if (this.patternArtifactId == null ? elementMatcherOther.patternArtifactId != null : !this.patternArtifactId.toString().equals(elementMatcherOther.patternArtifactId.toString())) {
                return false;
            }
            if (this.artifactVersion == null ? elementMatcherOther.artifactVersion != null : !this.artifactVersion.equals(elementMatcherOther.artifactVersion)) {
                return false;
            }
            return !(this.patternLiteralArtifactVersion == null ? elementMatcherOther.patternLiteralArtifactVersion != null : !this.patternLiteralArtifactVersion.toString().equals(elementMatcherOther.patternLiteralArtifactVersion.toString()));
        }

        private static class PartMatcher {
            private String string;
            private Pattern pattern;

            private PartMatcher() {
            }
        }
    }
}

