/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.azyva.dragom.model.NodePath;
import org.azyva.dragom.model.Version;

public final class ModuleVersion {
    private static final String MSG_PATTERN_KEY_MODULE_VERSION_PARSING_ERROR = "MODULE_VERSION_PARSING_ERROR";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(ModuleVersion.class.getName() + "ResourceBundle");
    private static final Pattern patternModuleVersionLiteral = Pattern.compile("([^:]+)(?::([^:]+))?");
    private NodePath nodePath;
    private Version version;

    public ModuleVersion(NodePath nodePath, Version version) {
        if (nodePath == null) {
            throw new RuntimeException("NodePath cannot be null.");
        }
        if (nodePath.isPartial()) {
            throw new RuntimeException("The NodePath " + nodePath + " must not be partial.");
        }
        this.nodePath = nodePath;
        this.version = version;
    }

    public ModuleVersion(NodePath nodePath) {
        if (nodePath == null) {
            throw new RuntimeException("NodePath cannot be null.");
        }
        if (nodePath.isPartial()) {
            throw new RuntimeException("The NodsePath " + nodePath + " must not be partial.");
        }
        this.nodePath = nodePath;
    }

    public ModuleVersion(String stringModuleVersion) {
        block5: {
            Matcher matcher = patternModuleVersionLiteral.matcher(stringModuleVersion);
            try {
                if (!matcher.matches()) {
                    throw new ParseException(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MODULE_VERSION_PARSING_ERROR), stringModuleVersion, patternModuleVersionLiteral), 0);
                }
                this.nodePath = NodePath.parse(matcher.group(1));
                if (matcher.group(2) == null) break block5;
                try {
                    this.version = Version.parse(matcher.group(2));
                }
                catch (ParseException pe) {
                    throw new ParseException(pe.getMessage(), pe.getErrorOffset() + matcher.start(2));
                }
            }
            catch (ParseException pe) {
                throw new RuntimeException(pe);
            }
        }
    }

    public static ModuleVersion parse(String stringModuleVersion) throws ParseException {
        try {
            return new ModuleVersion(stringModuleVersion);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ParseException) {
                throw (ParseException)re.getCause();
            }
            throw re;
        }
    }

    public NodePath getNodePath() {
        return this.nodePath;
    }

    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        if (this.version == null) {
            return this.nodePath.toString();
        }
        return this.nodePath.toString() + ':' + this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.nodePath.hashCode();
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModuleVersion)) {
            return false;
        }
        ModuleVersion moduleVersionOther = (ModuleVersion)other;
        if (!this.nodePath.equals(moduleVersionOther.nodePath)) {
            return false;
        }
        return !(this.version == null ? moduleVersionOther.version != null : !this.version.equals(moduleVersionOther.version));
    }
}

