/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.azyva.dragom.model.ArtifactVersion;
import org.azyva.dragom.model.VersionType;

public final class Version {
    private static final String MSG_PATTERN_KEY_VERSION_PARSING_ERROR = "VERSION_PARSING_ERROR";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(Version.class.getName() + "ResourceBundle");
    private static final Pattern patternVersionLiteral = Pattern.compile("(D|S)/([a-zA-Z0-9\\.\\-_]+)");
    private VersionType versionType;
    private String version;

    public Version(VersionType versionType, String version) {
        if (versionType == null || version == null) {
            throw new RuntimeException("Version type or version cannot be null.");
        }
        if (version.length() == 0) {
            throw new RuntimeException("Version cannot be the empty string.");
        }
        this.versionType = versionType;
        this.version = version;
    }

    public Version(String stringVersion) {
        Matcher matcher = patternVersionLiteral.matcher(stringVersion);
        try {
            if (!matcher.matches()) {
                throw new ParseException(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_VERSION_PARSING_ERROR), stringVersion, patternVersionLiteral), 0);
            }
            this.versionType = matcher.group(1).charAt(0) == 'D' ? VersionType.DYNAMIC : VersionType.STATIC;
            this.version = matcher.group(2);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    public static Version parse(String stringVersion) throws ParseException {
        try {
            return new Version(stringVersion);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ParseException) {
                throw (ParseException)re.getCause();
            }
            throw re;
        }
    }

    public VersionType getVersionType() {
        return this.versionType;
    }

    public String getVersion() {
        return this.version;
    }

    public ArtifactVersion getCorrespondingArtifactVersion() {
        return new ArtifactVersion(this.versionType, this.version);
    }

    public String toString() {
        switch (this.versionType) {
            case DYNAMIC: {
                return "D/" + this.version;
            }
            case STATIC: {
                return "S/" + this.version;
            }
        }
        throw new RuntimeException("Invalid version type " + (Object)((Object)this.versionType) + '.');
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.versionType.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version versionOther = (Version)other;
        return this.versionType == versionOther.versionType && this.version.equals(versionOther.version);
    }
}

