/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.azyva.dragom.model.ArtifactGroupId;
import org.azyva.dragom.model.ArtifactVersion;

public final class ArtifactGroupIdVersion {
    private static final String MSG_PATTERN_KEY_ARTIFACT_GROUP_ID_VERSION_PARSING_ERROR = "ARTIFACT_GROUP_ID_VERSION_PARSING_ERROR";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(ArtifactGroupIdVersion.class.getName() + "ResourceBundle");
    private static final Pattern patternArtifactGroupIdLiteral = Pattern.compile("([a-zA-Z][a-zA-Z0-9\\.\\-_]*):([a-zA-Z][a-zA-Z0-9\\.\\-_]*):([a-zA-Z0-9\\.\\-_]+)(-SNAPSHOT)?");
    private ArtifactGroupId artifactGroupId;
    private ArtifactVersion artifactVersion;

    public ArtifactGroupIdVersion(ArtifactGroupId artifactGroupId, ArtifactVersion artifactVersion) {
        if (artifactGroupId == null || artifactVersion == null) {
            throw new RuntimeException("The artifactGroupId and artifactVersion cannot be null.");
        }
        this.artifactGroupId = artifactGroupId;
        this.artifactVersion = artifactVersion;
    }

    public ArtifactGroupIdVersion(String stringArtifactGroupIdVersion) {
        Matcher matcher = patternArtifactGroupIdLiteral.matcher(stringArtifactGroupIdVersion);
        try {
            if (!matcher.matches()) {
                throw new ParseException(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ARTIFACT_GROUP_ID_VERSION_PARSING_ERROR), stringArtifactGroupIdVersion, patternArtifactGroupIdLiteral), 0);
            }
            this.artifactGroupId = new ArtifactGroupId(matcher.group(1), matcher.group(2));
            this.artifactVersion = new ArtifactVersion(matcher.group(3));
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    public static ArtifactGroupIdVersion parse(String stringArtifactGroupId) throws ParseException {
        try {
            return new ArtifactGroupIdVersion(stringArtifactGroupId);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ParseException) {
                throw (ParseException)re.getCause();
            }
            throw re;
        }
    }

    public ArtifactGroupId getArtifactGroupId() {
        return this.artifactGroupId;
    }

    public ArtifactVersion getArtifactVersion() {
        return this.artifactVersion;
    }

    public String toString() {
        return this.artifactGroupId.toString() + ':' + this.artifactVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.artifactGroupId.hashCode();
        result = 31 * result + this.artifactVersion.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArtifactGroupIdVersion)) {
            return false;
        }
        ArtifactGroupIdVersion artifactGroupIdVersionOther = (ArtifactGroupIdVersion)other;
        return this.artifactGroupId.equals(artifactGroupIdVersionOther.artifactGroupId) && this.artifactVersion.equals(artifactGroupIdVersionOther.artifactVersion);
    }
}

