/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.VersionType;

public final class ArtifactVersion {
    public static final String DYNAMIC_VERSION_SUFFIX = "-SNAPSHOT";
    private static final String MSG_PATTERN_KEY_ARTIFACT_VERSION_PARSING_ERROR = "ARTIFACT_VERSION_PARSING_ERROR";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(ArtifactVersion.class.getName() + "ResourceBundle");
    private static final Pattern patternArtifactVersionLiteral = Pattern.compile("([a-zA-Z0-9\\.\\-_]+?)(-SNAPSHOT)?");
    private VersionType versionType;
    private String version;

    public ArtifactVersion(VersionType versionType, String version) {
        if (versionType == null || version == null) {
            throw new RuntimeException("Version type or version cannot be null.");
        }
        if (version.length() == 0) {
            throw new RuntimeException("Version cannot be the empty string.");
        }
        this.versionType = versionType;
        this.version = version;
    }

    public ArtifactVersion(String stringArtifactVersion) {
        Matcher matcher = patternArtifactVersionLiteral.matcher(stringArtifactVersion);
        try {
            if (!matcher.matches()) {
                throw new ParseException(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ARTIFACT_VERSION_PARSING_ERROR), stringArtifactVersion, patternArtifactVersionLiteral), 0);
            }
            this.version = matcher.group(1);
            this.versionType = matcher.group(2) != null ? VersionType.DYNAMIC : VersionType.STATIC;
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    public static ArtifactVersion parse(String stringArtifactVersion) throws ParseException {
        try {
            return new ArtifactVersion(stringArtifactVersion);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ParseException) {
                throw (ParseException)re.getCause();
            }
            throw re;
        }
    }

    public VersionType getVersionType() {
        return this.versionType;
    }

    public String getVersion() {
        return this.version;
    }

    public Version getCorrespondingVersion() {
        return new Version(this.versionType, this.version);
    }

    public String toString() {
        switch (this.versionType) {
            case DYNAMIC: {
                return this.version + DYNAMIC_VERSION_SUFFIX;
            }
            case STATIC: {
                return this.version;
            }
        }
        throw new RuntimeException("Invalid version type " + (Object)((Object)this.versionType) + '.');
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.versionType.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArtifactVersion)) {
            return false;
        }
        ArtifactVersion versionOther = (ArtifactVersion)other;
        return this.versionType == versionOther.versionType && this.version.equals(versionOther.version);
    }
}

