/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NodePath {
    private static final String MSG_PATTERN_KEY_NODE_PATH_PARSING_ERROR = "NODE_PATH_PARSING_ERROR";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(NodePath.class.getName() + "ResourceBundle");
    private static final Pattern patternValidateNodePathLiteral = Pattern.compile("(?:[A-Za-z0-9_][A-Za-z0-9\\-_]*/)*(?:[A-Za-z0-9_][A-Za-z0-9\\-_]*)?");
    private static Pattern patternValidateNodeName = Pattern.compile("[A-Za-z0-9_][A-Za-z0-9\\-_]*");
    private String[] arrayNodeName;
    private boolean isPartial;

    public NodePath(String[] arrayNodeName) {
        this(arrayNodeName, false);
    }

    public NodePath(String[] arrayNodeName, boolean isPartial) {
        if (arrayNodeName.length == 0 && !isPartial) {
            throw new RuntimeException("A NodePath cannot be empty.");
        }
        for (String nodeName : arrayNodeName) {
            if (NodePath.validateNodeName(nodeName)) continue;
            throw new RuntimeException("Node name " + nodeName + " is invalid.");
        }
        this.arrayNodeName = Arrays.copyOf(arrayNodeName, arrayNodeName.length);
        this.isPartial = isPartial;
    }

    public NodePath(NodePath nodePathParent, String moduleName) {
        this(nodePathParent, moduleName, false);
    }

    public NodePath(NodePath nodePathParent, String nodeName, boolean isPartial) {
        if (!NodePath.validateNodeName(nodeName)) {
            throw new RuntimeException("Node name " + nodeName + " is invalid.");
        }
        if (nodePathParent != null) {
            if (!nodePathParent.isPartial()) {
                throw new RuntimeException("A node cannot be appended to a complete NodsePath " + nodePathParent + '.');
            }
            this.arrayNodeName = new String[nodePathParent.arrayNodeName.length + 1];
            System.arraycopy(nodePathParent.arrayNodeName, 0, this.arrayNodeName, 0, nodePathParent.arrayNodeName.length);
            this.arrayNodeName[this.arrayNodeName.length - 1] = nodeName;
            this.isPartial = isPartial;
        } else {
            this.arrayNodeName = new String[1];
            this.arrayNodeName[0] = nodeName;
            this.isPartial = isPartial;
        }
    }

    private NodePath() {
    }

    public NodePath(String stringNodePath) {
        if (stringNodePath.isEmpty()) {
            this.isPartial = true;
            this.arrayNodeName = new String[0];
        } else {
            try {
                Matcher matcher = patternValidateNodePathLiteral.matcher(stringNodePath);
                if (!matcher.matches()) {
                    throw new ParseException(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_NODE_PATH_PARSING_ERROR), stringNodePath, patternValidateNodePathLiteral), 0);
                }
                if (stringNodePath.charAt(stringNodePath.length() - 1) == '/') {
                    this.isPartial = true;
                    stringNodePath = stringNodePath.substring(0, stringNodePath.length() - 1);
                } else {
                    this.isPartial = false;
                }
                this.arrayNodeName = stringNodePath.split("/");
            }
            catch (ParseException pe) {
                throw new RuntimeException(pe);
            }
        }
    }

    public static NodePath parse(String stringNodePath) throws ParseException {
        try {
            return new NodePath(stringNodePath);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ParseException) {
                throw (ParseException)re.getCause();
            }
            throw re;
        }
    }

    public String[] getArrayNodeName() {
        return Arrays.copyOf(this.arrayNodeName, this.arrayNodeName.length);
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public int getNodeCount() {
        return this.arrayNodeName.length;
    }

    public String getNodeName(int index) {
        if (index >= this.arrayNodeName.length) {
            throw new RuntimeException("The index " + index + " is larger than the index of the last node of the NodsePath " + this + '.');
        }
        return this.arrayNodeName[index];
    }

    public NodePath getNodePathParent() {
        NodePath nodePathParent = new NodePath();
        nodePathParent.arrayNodeName = Arrays.copyOfRange(this.arrayNodeName, 0, this.arrayNodeName.length - 1);
        nodePathParent.isPartial = true;
        return nodePathParent;
    }

    public NodePath getNodePathPartial() {
        if (this.isPartial) {
            return this;
        }
        return this.getNodePathParent();
    }

    public String getModuleName() {
        if (this.isPartial) {
            throw new RuntimeException("The NodsePath " + this + " is partial and has no module.");
        }
        return this.arrayNodeName[this.arrayNodeName.length - 1];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String nodeName : this.arrayNodeName) {
            stringBuilder.append(nodeName).append("/");
        }
        if (!this.isPartial) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public String getPropertyNameSegment() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String nodeName : this.arrayNodeName) {
            stringBuilder.append(nodeName).append('.');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private static boolean validateNodeName(String nodeName) {
        Matcher matcher = patternValidateNodeName.matcher(nodeName);
        return matcher.matches();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode(this.arrayNodeName);
        result = 31 * result + (this.isPartial ? 1 : 0);
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NodePath)) {
            return false;
        }
        NodePath nodePathOther = (NodePath)other;
        return Arrays.equals(this.arrayNodeName, nodePathOther.arrayNodeName) && this.isPartial == nodePathOther.isPartial;
    }
}

