/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin;

import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.plugin.ModulePlugin;

public interface ScmPlugin
extends ModulePlugin {
    public static final String COMMIT_ATTR_EQUIVALENT_STATIC_VERSION = "dragom-equivalent-static-version";
    public static final String COMMIT_ATTR_VERSION_CHANGE = "dragom-version-change";
    public static final String COMMIT_ATTR_REFERENCE_VERSION_CHANGE = "dragom-reference-version-change";
    public static final String VERSION_ATTR_PROJECT_CODE = "dragom-project-code";

    public boolean isModuleExists();

    public Version getDefaultVersion();

    public void checkout(Version var1, Path var2);

    public Path checkoutSystem(Version var1);

    public boolean isVersionExists(Version var1);

    public boolean isSync(Path var1, EnumSet<IsSyncFlag> var2);

    public boolean update(Path var1);

    public Version getVersion(Path var1);

    public List<Commit> getListCommit(Version var1, CommitPaging var2, EnumSet<GetListCommitFlag> var3);

    public List<Commit> getListCommitDiverge(Version var1, Version var2, CommitPaging var3, EnumSet<GetListCommitFlag> var4);

    public BaseVersion getBaseVersion(Version var1);

    public List<Version> getListVersionStatic();

    public void switchVersion(Path var1, Version var2);

    public void createVersion(Path var1, Version var2, Map<String, String> var3, boolean var4);

    public Map<String, String> getMapVersionAttr(Version var1);

    public void createTempDynamicVersion(Path var1);

    public boolean isTempDynamicVersion(Version var1);

    public void releaseTempDynamicVersion(Path var1);

    public void commit(Path var1, String var2, Map<String, String> var3);

    public MergeResult merge(Path var1, Version var2, String var3);

    public MergeResult mergeExcludeCommits(Path var1, Version var2, List<Commit> var3, String var4);

    public MergeResult replace(Path var1, Version var2, String var3);

    public String getScmType();

    public String getScmUrl(Path var1);

    public static enum MergeResult {
        MERGED,
        CONFLICTS,
        NOTHING_TO_MERGE;

    }

    public static enum IsSyncFlag {
        LOCAL_CHANGES,
        REMOTE_CHANGES;

        public static final EnumSet<IsSyncFlag> LOCAL_CHANGES_ONLY;
        public static final EnumSet<IsSyncFlag> REMOTE_CHANGES_ONLY;
        public static final EnumSet<IsSyncFlag> ALL_CHANGES;

        static {
            LOCAL_CHANGES_ONLY = EnumSet.of(LOCAL_CHANGES);
            REMOTE_CHANGES_ONLY = EnumSet.of(REMOTE_CHANGES);
            ALL_CHANGES = EnumSet.of(LOCAL_CHANGES, REMOTE_CHANGES);
        }
    }

    public static class BaseVersion {
        public Version version;
        public Version versionBase;
        public String commitId;
    }

    public static enum GetListCommitFlag {
        IND_INCLUDE_MESSAGE,
        IND_INCLUDE_VERSION_STATIC,
        IND_INCLUDE_MAP_ATTR,
        IND_UPDATE_START_INDEX;

    }

    public static class CommitPaging {
        public int startIndex;
        public int maxCount;
        public int returned;
        public boolean indDone;

        public CommitPaging() {
            this.maxCount = -1;
        }

        public CommitPaging(int maxCount) {
            this.maxCount = maxCount;
        }
    }

    public static class Commit {
        public String id;
        public String message;
        public Version[] arrayVersionStatic;
        public Map<String, String> mapAttr;

        public String toString() {
            return "ScmPlugin.Commit [id=" + this.id + (this.message == null ? "" : ", message=" + this.message) + ']';
        }
    }
}

